/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.V3ChallengeIndividualRequest;
import com.prove.proveapi.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V3ChallengeResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="individual")
    private Optional<? extends V3ChallengeIndividualRequest> individual;
    @JsonProperty(value="next")
    private Map<String, String> next;
    @JsonProperty(value="success")
    private boolean success;

    @JsonCreator
    public V3ChallengeResponse(@JsonProperty(value="individual") Optional<? extends V3ChallengeIndividualRequest> individual, @JsonProperty(value="next") Map<String, String> next, @JsonProperty(value="success") boolean success) {
        Utils.checkNotNull(individual, "individual");
        next = Utils.emptyMapIfNull(next);
        Utils.checkNotNull(success, "success");
        this.individual = individual;
        this.next = next;
        this.success = success;
    }

    public V3ChallengeResponse(Map<String, String> next, boolean success) {
        this(Optional.empty(), next, success);
    }

    @JsonIgnore
    public Optional<V3ChallengeIndividualRequest> individual() {
        return this.individual;
    }

    @JsonIgnore
    public Map<String, String> next() {
        return this.next;
    }

    @JsonIgnore
    public boolean success() {
        return this.success;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ChallengeResponse withIndividual(V3ChallengeIndividualRequest individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = Optional.ofNullable(individual);
        return this;
    }

    public V3ChallengeResponse withIndividual(Optional<? extends V3ChallengeIndividualRequest> individual) {
        Utils.checkNotNull(individual, "individual");
        this.individual = individual;
        return this;
    }

    public V3ChallengeResponse withNext(Map<String, String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    public V3ChallengeResponse withSuccess(boolean success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ChallengeResponse other = (V3ChallengeResponse)o;
        return Objects.deepEquals(this.individual, other.individual) && Objects.deepEquals(this.next, other.next) && Objects.deepEquals(this.success, other.success);
    }

    public int hashCode() {
        return Objects.hash(this.individual, this.next, this.success);
    }

    public String toString() {
        return Utils.toString(V3ChallengeResponse.class, "individual", this.individual, "next", this.next, "success", this.success);
    }

    public static final class Builder {
        private Optional<? extends V3ChallengeIndividualRequest> individual = Optional.empty();
        private Map<String, String> next;
        private Boolean success;

        private Builder() {
        }

        public Builder individual(V3ChallengeIndividualRequest individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = Optional.ofNullable(individual);
            return this;
        }

        public Builder individual(Optional<? extends V3ChallengeIndividualRequest> individual) {
            Utils.checkNotNull(individual, "individual");
            this.individual = individual;
            return this;
        }

        public Builder next(Map<String, String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public Builder success(boolean success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }

        public V3ChallengeResponse build() {
            return new V3ChallengeResponse(this.individual, this.next, this.success);
        }
    }
}

