/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi;

import com.prove.proveapi.SDKConfiguration;
import com.prove.proveapi.SecuritySource;
import com.prove.proveapi.V3;
import com.prove.proveapi.models.components.Security;
import com.prove.proveapi.utils.HTTPClient;
import com.prove.proveapi.utils.Hooks;
import com.prove.proveapi.utils.RetryConfig;
import com.prove.proveapi.utils.SpeakeasyHTTPClient;
import com.prove.proveapi.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Proveapi {
    public static final Map<AvailableServers, String> SERVERS = new HashMap<AvailableServers, String>(){
        {
            this.put(AvailableServers.UAT_US, "https://platform.uat.proveapis.com");
            this.put(AvailableServers.PROD_US, "https://platform.proveapis.com");
        }
    };
    private final V3 v3;
    private final SDKConfiguration sdkConfiguration;

    public V3 v3() {
        return this.v3;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Proveapi(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.v3 = new V3(sdkConfiguration);
        this.sdkConfiguration.initialize();
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.defaultClient = client;
            return this;
        }

        public Builder security(Security security) {
            this.sdkConfiguration.securitySource = SecuritySource.of(security);
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            this.sdkConfiguration.securitySource = securitySource;
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.sdkConfiguration.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.sdkConfiguration.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder server(AvailableServers server) {
            this.sdkConfiguration.server = server.toString();
            this.sdkConfiguration.serverUrl = SERVERS.get((Object)server);
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.retryConfig = Optional.of(retryConfig);
            return this;
        }

        void _hooks(Hooks hooks) {
            this.sdkConfiguration.setHooks(hooks);
        }

        public Proveapi build() {
            if (this.sdkConfiguration.defaultClient == null) {
                this.sdkConfiguration.defaultClient = new SpeakeasyHTTPClient();
            }
            if (this.sdkConfiguration.securitySource == null) {
                this.sdkConfiguration.securitySource = SecuritySource.of(null);
            }
            if (this.sdkConfiguration.serverUrl == null || this.sdkConfiguration.serverUrl.isBlank()) {
                this.sdkConfiguration.serverUrl = SERVERS.get((Object)AvailableServers.UAT_US);
                this.sdkConfiguration.server = AvailableServers.UAT_US.toString();
            }
            if (this.sdkConfiguration.serverUrl.endsWith("/")) {
                this.sdkConfiguration.serverUrl = this.sdkConfiguration.serverUrl.substring(0, this.sdkConfiguration.serverUrl.length() - 1);
            }
            return new Proveapi(this.sdkConfiguration);
        }
    }

    public static enum AvailableServers {
        UAT_US("uat-us"),
        PROD_US("prod-us");

        private final String server;

        private AvailableServers(String server) {
            this.server = server;
        }

        public String server() {
            return this.server;
        }
    }
}

