/*
 * Decompiled with CFR 0.152.
 */
package lists.LinkedListNumbers.LinkedListNumbersFunctions;

import lists.LinkedListNumbers.Structures.LinkedListNodeNumbers;
import lists.LinkedListNumbers.Structures.LinkedListNumbers;

public class LinkedListNumbersFunctions {
    public static LinkedListNumbers CreateLinkedListNumbers() {
        LinkedListNumbers ll = new LinkedListNumbers();
        ll.last = ll.first = new LinkedListNodeNumbers();
        ll.last.end = true;
        return ll;
    }

    public static LinkedListNumbers[] CreateLinkedListNumbersArray(double length) {
        LinkedListNumbers[] lls = new LinkedListNumbers[(int)length];
        for (double i = 0.0; i < (double)lls.length; i += 1.0) {
            lls[(int)i] = LinkedListNumbersFunctions.CreateLinkedListNumbers();
        }
        return lls;
    }

    public static void LinkedListAddNumber(LinkedListNumbers ll, double value) {
        ll.last.end = false;
        ll.last.value = value;
        ll.last.next = new LinkedListNodeNumbers();
        ll.last.next.end = true;
        ll.last = ll.last.next;
    }

    public static double LinkedListNumbersLength(LinkedListNumbers ll) {
        double l = 0.0;
        LinkedListNodeNumbers node = ll.first;
        while (!node.end) {
            node = node.next;
            l += 1.0;
        }
        return l;
    }

    public static double LinkedListNumbersIndex(LinkedListNumbers ll, double index) {
        LinkedListNodeNumbers node = ll.first;
        for (double i = 0.0; i < index; i += 1.0) {
            node = node.next;
        }
        return node.value;
    }

    public static void LinkedListInsertNumber(LinkedListNumbers ll, double index, double value) {
        if (index == 0.0) {
            LinkedListNodeNumbers tmp = ll.first;
            ll.first = new LinkedListNodeNumbers();
            ll.first.next = tmp;
            ll.first.value = value;
            ll.first.end = false;
        } else {
            LinkedListNodeNumbers node = ll.first;
            for (double i = 0.0; i < index - 1.0; i += 1.0) {
                node = node.next;
            }
            LinkedListNodeNumbers tmp = node.next;
            node.next = new LinkedListNodeNumbers();
            node.next.next = tmp;
            node.next.value = value;
            node.next.end = false;
        }
    }

    public static void LinkedListSet(LinkedListNumbers ll, double index, double value) {
        LinkedListNodeNumbers node = ll.first;
        for (double i = 0.0; i < index; i += 1.0) {
            node = node.next;
        }
        node.next.value = value;
    }

    public static void LinkedListRemoveNumber(LinkedListNumbers ll, double index) {
        LinkedListNodeNumbers node = ll.first;
        LinkedListNodeNumbers prev = ll.first;
        for (double i = 0.0; i < index; i += 1.0) {
            prev = node;
            node = node.next;
        }
        if (index == 0.0) {
            ll.first = prev.next;
        }
        if (!prev.next.end) {
            prev.next = prev.next.next;
        }
    }

    public static void FreeLinkedListNumbers(LinkedListNumbers ll) {
        LinkedListNodeNumbers node = ll.first;
        while (!node.end) {
            LinkedListNodeNumbers prev = node;
            node = node.next;
            LinkedListNumbersFunctions.delete(prev);
        }
        LinkedListNumbersFunctions.delete(node);
    }

    public static void FreeLinkedListNumbersArray(LinkedListNumbers[] lls) {
        for (double i = 0.0; i < (double)lls.length; i += 1.0) {
            LinkedListNumbersFunctions.FreeLinkedListNumbers(lls[(int)i]);
        }
        LinkedListNumbersFunctions.delete(lls);
    }

    public static double[] LinkedListNumbersToArray(LinkedListNumbers ll) {
        LinkedListNodeNumbers node = ll.first;
        double length = LinkedListNumbersFunctions.LinkedListNumbersLength(ll);
        double[] array = new double[(int)length];
        for (double i = 0.0; i < length; i += 1.0) {
            array[(int)i] = node.value;
            node = node.next;
        }
        return array;
    }

    public static LinkedListNumbers ArrayToLinkedListNumbers(double[] array) {
        LinkedListNumbers ll = LinkedListNumbersFunctions.CreateLinkedListNumbers();
        for (double i = 0.0; i < (double)array.length; i += 1.0) {
            LinkedListNumbersFunctions.LinkedListAddNumber(ll, array[(int)i]);
        }
        return ll;
    }

    public static boolean LinkedListNumbersEqual(LinkedListNumbers a, LinkedListNumbers b) {
        LinkedListNodeNumbers an = a.first;
        LinkedListNodeNumbers bn = b.first;
        boolean equal = true;
        boolean done = false;
        while (equal && !done) {
            if (an.end == bn.end) {
                if (an.end) {
                    done = true;
                    continue;
                }
                if (an.value == bn.value) {
                    an = an.next;
                    bn = bn.next;
                    continue;
                }
                equal = false;
                continue;
            }
            equal = false;
        }
        return equal;
    }

    public static void delete(Object object) {
    }
}

