/*
 * Decompiled with CFR 0.152.
 */
package com.progsbase.libraries.JSON;

import JSON.StringElementMaps.StringElementMap;
import JSON.StringElementMaps.StringElementMaps;
import JSON.parser.parser;
import JSON.structures.Element;
import JSON.structures.ElementReference;
import com.progsbase.libraries.JSON.JSONException;
import com.progsbase.libraries.JSON.Reference;
import com.progsbase.libraries.JSON.StringReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import references.references.StringArrayReference;
import references.references.references;

public class JSONReflectiveReader {
    public static <T> boolean readJSON(String json2, Reference<T> tReference, Class<T> clazz, StringReference errorMessage) {
        return JSONReflectiveReader.readJSON(json2, tReference, clazz, null, errorMessage);
    }

    public static <T> boolean readJSON(String json2, Reference<T> tReference, Class<T> clazz, Type genericType, StringReference errorMessage) {
        boolean success;
        try {
            tReference.t = JSONReflectiveReader.readJSON(json2, clazz, genericType);
            success = true;
        }
        catch (JSONException e) {
            success = false;
            errorMessage.string = e.getMessage();
        }
        return success;
    }

    public static <T> T readJSON(String json2, Class<T> clazz) throws JSONException {
        return JSONReflectiveReader.readJSON(json2, clazz, null);
    }

    public static <T> T readJSON(String json2, Class<T> clazz, Type genericType) throws JSONException {
        T t = null;
        ElementReference elementReference = new ElementReference();
        StringArrayReference errorMessages = references.CreateStringArrayReferenceLengthValue(0.0, "".toCharArray());
        boolean success = parser.ReadJSON(json2.toCharArray(), elementReference, errorMessages);
        if (!success) {
            throw new JSONException(JSONReflectiveReader.join(errorMessages.stringArray, "\n"));
        }
        t = JSONReflectiveReader.javaifyJSONValue(elementReference.element, clazz, genericType);
        return t;
    }

    public static String join(references.references.StringReference[] stringArray, String s) {
        StringBuilder joined = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            joined.append(new String(stringArray[i].string));
            if (i + 1 >= stringArray.length) continue;
            joined.append(s);
        }
        return joined.toString();
    }

    public static <T> T javaifyJSONValue(Element element, Class<T> clazz, Type genericType) throws JSONException {
        Object t = null;
        String type = new String(element.type);
        if (!type.equals("null")) {
            if (type.equals("object")) {
                t = JSONReflectiveReader.javaifyJSONObject(element.object, clazz);
            } else if (type.equals("array")) {
                t = JSONReflectiveReader.javaifyJSONArray(element.array, clazz, genericType);
            } else if (type.equals("string")) {
                if (clazz == String.class) {
                    t = new String(element.string);
                }
                if (clazz.isEnum()) {
                    Method valueOf;
                    try {
                        valueOf = clazz.getMethod("valueOf", String.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JSONException(e.getMessage());
                    }
                    try {
                        t = valueOf.invoke(null, new String(element.string));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new JSONException(e.getMessage());
                    }
                }
            } else if (type.equals("number")) {
                if (clazz == Double.class || clazz == Double.TYPE) {
                    t = new Double(element.number);
                }
                if (clazz == Float.class || clazz == Float.TYPE) {
                    t = new Float(element.number);
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    t = new Integer((int)Math.round(element.number));
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    t = new Long(Math.round(element.number));
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    t = new Short((short)Math.round(element.number));
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    t = new Byte((byte)Math.round(element.number));
                }
            } else if (type.equals("boolean") && (clazz == Boolean.class || clazz == Boolean.TYPE)) {
                t = element.booleanValue;
            }
        }
        return (T)t;
    }

    public static <T> T javaifyJSONObject(StringElementMap object, Class<T> clazz) throws JSONException {
        T t;
        try {
            t = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException(e);
        }
        int i = 0;
        while ((double)i < StringElementMaps.GetStringElementMapNumberOfKeys(object)) {
            try {
                String key = new String(object.stringListRef.stringArray[i].string);
                Field field = clazz.getField(key);
                Object value = JSONReflectiveReader.javaifyJSONValue(object.elementListRef.array[i], field.getType(), field.getGenericType());
                field.set(t, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new JSONException(e);
            }
            ++i;
        }
        return t;
    }

    public static <T> T javaifyJSONArray(Element[] array, Class<T> clazz, Type genericType) throws JSONException {
        Type typeGeneric;
        Class typeClass;
        Class<?> componentType = clazz.getComponentType();
        if (componentType != null) {
            Object[] a = (Object[])Array.newInstance(componentType, array.length);
            for (int i = 0; i < array.length; ++i) {
                a[i] = JSONReflectiveReader.javaifyJSONValue(array[i], componentType, null);
            }
            return (T)a;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        ParameterizedType p = (ParameterizedType)genericType;
        Type type = p.getActualTypeArguments()[0];
        if (type instanceof Class) {
            typeClass = (Class)type;
            typeGeneric = null;
        } else {
            typeClass = List.class;
            typeGeneric = type;
        }
        for (int i = 0; i < array.length; ++i) {
            list.add(JSONReflectiveReader.javaifyJSONValue(array[i], typeClass, typeGeneric));
        }
        return (T)list;
    }
}

