/*
 * Decompiled with CFR 0.152.
 */
package JSON.parser;

import JSON.LinkedListElements.LinkedListElementsFunctions.LinkedListElementsFunctions;
import JSON.LinkedListElements.Structures.LinkedListElements;
import JSON.json.json;
import JSON.structures.Element;
import JSON.structures.ElementReference;
import JSON.tokenReader.tokenReader;
import arrays.arrays.arrays;
import charCharacters.Characters.Characters;
import lists.LinkedListStrings.LinkedListStringsFunctions.LinkedListStringsFunctions;
import lists.LinkedListStrings.Structures.LinkedListStrings;
import lists.StringList.StringList;
import nnumbers.StringToNumber.StringToNumber;
import references.references.NumberReference;
import references.references.StringArrayReference;
import references.references.StringReference;
import references.references.references;
import strstrings.strings.strings;

public class parser {
    public static boolean ReadJSON(char[] string, ElementReference elementReference, StringArrayReference errorMessages) {
        StringArrayReference tokenArrayReference = new StringArrayReference();
        boolean success = tokenReader.JSONTokenize(string, tokenArrayReference, errorMessages);
        if (success) {
            success = parser.GetJSONValue(tokenArrayReference.stringArray, elementReference, errorMessages);
        }
        return success;
    }

    public static boolean GetJSONValue(StringReference[] tokens, ElementReference elementReference, StringArrayReference errorMessages) {
        NumberReference i = references.CreateNumberReference(0.0);
        boolean success = parser.GetJSONValueRecursive(tokens, i, 0.0, elementReference, errorMessages);
        return success;
    }

    public static boolean GetJSONValueRecursive(StringReference[] tokens, NumberReference i, double depth, ElementReference elementReference, StringArrayReference errorMessages) {
        boolean success = true;
        char[] token = tokens[(int)i.numberValue].string;
        if (arrays.StringsEqual(token, "{".toCharArray())) {
            success = parser.GetJSONObject(tokens, i, depth + 1.0, elementReference, errorMessages);
        } else if (arrays.StringsEqual(token, "[".toCharArray())) {
            success = parser.GetJSONArray(tokens, i, depth + 1.0, elementReference, errorMessages);
        } else if (arrays.StringsEqual(token, "true".toCharArray())) {
            elementReference.element = json.CreateBooleanElement(true);
            i.numberValue += 1.0;
        } else if (arrays.StringsEqual(token, "false".toCharArray())) {
            elementReference.element = json.CreateBooleanElement(false);
            i.numberValue += 1.0;
        } else if (arrays.StringsEqual(token, "null".toCharArray())) {
            elementReference.element = json.CreateNullElement();
            i.numberValue += 1.0;
        } else if (Characters.charIsNumber(token[0]) || token[0] == '-') {
            double stringToDecimalResult = StringToNumber.nCreateNumberFromDecimalString(token);
            elementReference.element = json.CreateNumberElement(stringToDecimalResult);
            i.numberValue += 1.0;
        } else if (token[0] == '\"') {
            char[] substr = strings.strSubstring(token, 1.0, (double)token.length - 1.0);
            elementReference.element = json.CreateStringElement(substr);
            i.numberValue += 1.0;
        } else {
            char[] str = "".toCharArray();
            str = strings.strConcatenateString(str, "Invalid token first in value: ".toCharArray());
            str = strings.strAppendString(str, token);
            StringList.AddStringRef(errorMessages, references.CreateStringReference(str));
            success = false;
        }
        if (success && depth == 0.0 && !arrays.StringsEqual(tokens[(int)i.numberValue].string, "<end>".toCharArray())) {
            StringList.AddStringRef(errorMessages, references.CreateStringReference("The outer value cannot have any tokens following it.".toCharArray()));
            success = false;
        }
        return success;
    }

    public static boolean GetJSONObject(StringReference[] tokens, NumberReference i, double depth, ElementReference elementReference, StringArrayReference errorMessages) {
        LinkedListStrings keys = LinkedListStringsFunctions.CreateLinkedListString();
        LinkedListElements values = LinkedListElementsFunctions.CreateLinkedListElements();
        Element element = json.CreateObjectElement(0.0);
        ElementReference valueReference = new ElementReference();
        boolean success = true;
        i.numberValue += 1.0;
        if (!arrays.StringsEqual(tokens[(int)i.numberValue].string, "}".toCharArray())) {
            boolean done = false;
            while (!done && success) {
                char[] key = tokens[(int)i.numberValue].string;
                if (key[0] == '\"') {
                    i.numberValue += 1.0;
                    char[] colon = tokens[(int)i.numberValue].string;
                    if (arrays.StringsEqual(colon, ":".toCharArray())) {
                        i.numberValue += 1.0;
                        success = parser.GetJSONValueRecursive(tokens, i, depth, valueReference, errorMessages);
                        if (!success) continue;
                        char[] keystring = strings.strSubstring(key, 1.0, (double)key.length - 1.0);
                        Element value = valueReference.element;
                        LinkedListStringsFunctions.LinkedListAddString(keys, keystring);
                        LinkedListElementsFunctions.LinkedListAddElement(values, value);
                        char[] comma = tokens[(int)i.numberValue].string;
                        if (arrays.StringsEqual(comma, ",".toCharArray())) {
                            i.numberValue += 1.0;
                            continue;
                        }
                        done = true;
                        continue;
                    }
                    char[] str = "".toCharArray();
                    str = strings.strConcatenateString(str, "Expected colon after key in object: ".toCharArray());
                    str = strings.strAppendString(str, colon);
                    StringList.AddStringRef(errorMessages, references.CreateStringReference(str));
                    success = false;
                    done = true;
                    continue;
                }
                StringList.AddStringRef(errorMessages, references.CreateStringReference("Expected string as key in object.".toCharArray()));
                done = true;
                success = false;
            }
        }
        if (success) {
            char[] closeCurly = tokens[(int)i.numberValue].string;
            if (arrays.StringsEqual(closeCurly, "}".toCharArray())) {
                parser.delete(element.object.stringListRef.stringArray);
                parser.delete(element.object.elementListRef.array);
                element.object.stringListRef.stringArray = LinkedListStringsFunctions.LinkedListStringsToArray(keys);
                element.object.elementListRef.array = LinkedListElementsFunctions.LinkedListElementsToArray(values);
                elementReference.element = element;
                i.numberValue += 1.0;
            } else {
                StringList.AddStringRef(errorMessages, references.CreateStringReference("Expected close curly brackets at end of object value.".toCharArray()));
                success = false;
            }
        }
        LinkedListStringsFunctions.FreeLinkedListString(keys);
        LinkedListElementsFunctions.FreeLinkedListElements(values);
        parser.delete(valueReference);
        return success;
    }

    public static boolean GetJSONArray(StringReference[] tokens, NumberReference i, double depth, ElementReference elementReference, StringArrayReference errorMessages) {
        LinkedListElements elements = LinkedListElementsFunctions.CreateLinkedListElements();
        i.numberValue += 1.0;
        ElementReference valueReference = new ElementReference();
        boolean success = true;
        Element element = json.CreateArrayElement(0.0);
        char[] nextToken = tokens[(int)i.numberValue].string;
        if (!arrays.StringsEqual(nextToken, "]".toCharArray())) {
            boolean done = false;
            while (!done && success) {
                success = parser.GetJSONValueRecursive(tokens, i, depth, valueReference, errorMessages);
                if (!success) continue;
                Element value = valueReference.element;
                LinkedListElementsFunctions.LinkedListAddElement(elements, value);
                char[] comma = tokens[(int)i.numberValue].string;
                if (arrays.StringsEqual(comma, ",".toCharArray())) {
                    i.numberValue += 1.0;
                    continue;
                }
                done = true;
            }
        }
        if (arrays.StringsEqual(nextToken = tokens[(int)i.numberValue].string, "]".toCharArray())) {
            i.numberValue += 1.0;
            parser.delete(element.array);
            element.array = LinkedListElementsFunctions.LinkedListElementsToArray(elements);
        } else {
            StringList.AddStringRef(errorMessages, references.CreateStringReference("Expected close square bracket at end of array.".toCharArray()));
            success = false;
        }
        elementReference.element = element;
        LinkedListElementsFunctions.FreeLinkedListElements(elements);
        parser.delete(valueReference);
        return success;
    }

    public static void delete(Object o) {
    }
}

