/*
 * Decompiled with CFR 0.152.
 */
package JSON.comparator;

import JSON.StringElementMaps.StringElementMap;
import JSON.StringElementMaps.StringElementMaps;
import JSON.json.json;
import JSON.parser.parser;
import JSON.structures.Element;
import JSON.structures.ElementReference;
import arrays.arrays.arrays;
import math.math.math;
import references.references.BooleanReference;
import references.references.StringArrayReference;

public class comparator {
    public static boolean JSONCompare(char[] a, char[] b, double epsilon, BooleanReference equal, StringArrayReference errorMessage) {
        ElementReference eaRef = new ElementReference();
        ElementReference ebRef = new ElementReference();
        boolean success = parser.ReadJSON(a, eaRef, errorMessage);
        if (success) {
            Element ea = eaRef.element;
            success = parser.ReadJSON(b, ebRef, errorMessage);
            if (success) {
                Element eb = ebRef.element;
                equal.booleanValue = comparator.JSONCompareElements(ea, eb, epsilon);
                json.DeleteElement(eb);
            }
            json.DeleteElement(ea);
        }
        return success;
    }

    public static boolean JSONCompareElements(Element ea, Element eb, double epsilon) {
        boolean equal = arrays.StringsEqual(ea.type, eb.type);
        if (equal) {
            char[] typeName = ea.type;
            if (arrays.StringsEqual(typeName, "object".toCharArray())) {
                equal = comparator.JSONCompareObjects(ea.object, eb.object, epsilon);
            } else if (arrays.StringsEqual(typeName, "string".toCharArray())) {
                equal = arrays.StringsEqual(ea.string, eb.string);
            } else if (arrays.StringsEqual(typeName, "array".toCharArray())) {
                equal = comparator.JSONCompareArrays(ea.array, eb.array, epsilon);
            } else if (arrays.StringsEqual(typeName, "number".toCharArray())) {
                equal = math.EpsilonCompare(ea.number, eb.number, epsilon);
            } else if (arrays.StringsEqual(typeName, "null".toCharArray())) {
                equal = true;
            } else if (arrays.StringsEqual(typeName, "boolean".toCharArray())) {
                equal = ea.booleanValue == eb.booleanValue;
            }
        }
        return equal;
    }

    public static boolean JSONCompareArrays(Element[] ea, Element[] eb, double epsilon) {
        boolean equals;
        boolean bl = equals = ea.length == eb.length;
        if (equals) {
            double length = ea.length;
            for (double i = 0.0; i < length && equals; i += 1.0) {
                equals = comparator.JSONCompareElements(ea[(int)i], eb[(int)i], epsilon);
            }
        }
        return equals;
    }

    public static boolean JSONCompareObjects(StringElementMap ea, StringElementMap eb, double epsilon) {
        double bkeys;
        boolean equals;
        BooleanReference aFoundReference = new BooleanReference();
        BooleanReference bFoundReference = new BooleanReference();
        double akeys = StringElementMaps.GetStringElementMapNumberOfKeys(ea);
        boolean bl = equals = akeys == (bkeys = StringElementMaps.GetStringElementMapNumberOfKeys(eb));
        if (equals) {
            StringArrayReference keys = StringElementMaps.GetStringElementMapKeySet(ea);
            for (double i = 0.0; i < (double)keys.stringArray.length && equals; i += 1.0) {
                char[] key = keys.stringArray[(int)i].string;
                Element eaValue = StringElementMaps.GetObjectValueWithCheck(ea, key, aFoundReference);
                Element ebValue = StringElementMaps.GetObjectValueWithCheck(eb, key, bFoundReference);
                equals = aFoundReference.booleanValue && bFoundReference.booleanValue ? comparator.JSONCompareElements(eaValue, ebValue, epsilon) : false;
            }
        }
        return equals;
    }
}

