/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.status;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaReadingException;
import net.praqma.prqa.parsers.MessageGroup;
import net.praqma.prqa.parsers.Rule;
import net.praqma.prqa.status.PRQAStatus;
import net.praqma.prqa.status.StatusCategory;

public class PRQAComplianceStatus
extends PRQAStatus
implements Serializable,
Comparable<PRQAComplianceStatus> {
    private int messages;
    private int messagesWithinThreshold;
    private Double fileCompliance;
    private Double projectCompliance;
    private Map<Integer, Integer> messagesByLevel = new TreeMap<Integer, Integer>();
    private List<MessageGroup> messagesGroups;

    public PRQAComplianceStatus() {
    }

    public PRQAComplianceStatus(int messages, Double fileCompliance, Double projectCompliance) {
        this();
        logger.finest("Constructor called for class PRQAComplianceStatus");
        logger.finest(String.format("Input parameter messages type: %s; value: %s", "int", messages));
        logger.finest(String.format("Input parameter fileCompliance type: %s; value: %s", fileCompliance.getClass(), fileCompliance));
        logger.finest(String.format("Input parameter projectCompliance type: %s; value: %s", projectCompliance.getClass(), projectCompliance));
        this.messages = messages;
        this.fileCompliance = fileCompliance;
        this.projectCompliance = projectCompliance;
        logger.finest("Ending execution of constructor - PRQAComplianceStatus");
    }

    public int getMessages() {
        logger.finest("Starting execution of method - getMessages");
        logger.finest(String.format("Returning value: %s", this.messages));
        return this.messages;
    }

    public void setMessages(int messages) {
        logger.finest("Starting execution of method - setMessages");
        logger.finest(String.format("Input parameter messages type: %s; value: %s", "int", messages));
        this.messages = messages;
        logger.finest("Ending execution of method - setMessages");
    }

    public Double getFileCompliance() {
        logger.finest("Starting execution of method - getFileCompliance");
        logger.finest(String.format("Returning value: %s", this.fileCompliance));
        return this.fileCompliance;
    }

    public void setFileCompliance(Double fileCompliance) {
        logger.finest("Starting execution of method - setFileCompliance");
        logger.finest(String.format("Input parameter fileCompliance type: %s; value: %s", fileCompliance.getClass(), fileCompliance));
        this.fileCompliance = fileCompliance;
        logger.finest("Ending execution of method - setFileCompliance");
    }

    public Double getProjectCompliance() {
        logger.finest("Starting execution of method - getProjectCompliance");
        logger.finest(String.format("Returning value: %s", this.projectCompliance));
        return this.projectCompliance;
    }

    public void setProjectCompliance(Double projCompliance) {
        logger.finest("Starting execution of method - setProjectCompliance");
        logger.finest(String.format("Input parameter projCompliance type: %s; value: %s", projCompliance.getClass(), projCompliance));
        this.projectCompliance = projCompliance;
        logger.finest("Ending execution of method - setProjectCompliance");
    }

    @Override
    public Number getReadout(StatusCategory cat) throws PrqaException {
        logger.finest("Starting execution of method - getReadout");
        logger.finest(String.format("Input parameter cat type: %s; value: %s", new Object[]{((Object)((Object)cat)).getClass(), cat}));
        switch (cat) {
            case ProjectCompliance: {
                Double output = this.getProjectCompliance();
                logger.finest(String.format("Returning value: %s", output));
                return output;
            }
            case Messages: {
                Integer output = this.getMessages();
                logger.finest(String.format("Returning value: %s", output));
                return output;
            }
            case FileCompliance: {
                Double output = this.getFileCompliance();
                logger.finest(String.format("Returning this.getFileCompliance(): %s", this.getFileCompliance()));
                return output;
            }
        }
        PrqaReadingException exception = new PrqaReadingException(String.format("Didn't find category %s for class %s", new Object[]{cat, this.getClass()}));
        logger.severe(String.format("Exception thrown type: %s; message: %s", exception.getClass(), exception.getMessage()));
        throw exception;
    }

    @Override
    public void setReadout(StatusCategory category, Number value) throws PrqaException {
        logger.finest("Starting execution of method - setReadout");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        logger.finest(String.format("Input parameter value type: %s; value: %s", value.getClass(), value));
        switch (category) {
            case ProjectCompliance: {
                double prjCompliance = value.doubleValue();
                logger.finest(String.format("Setting projectCompliance to: %s.", prjCompliance));
                this.setProjectCompliance(prjCompliance);
                logger.finest("Ending execution of method - setReadout");
                break;
            }
            case Messages: {
                int msgs = value.intValue();
                logger.finest(String.format("Setting messages to: %s.", msgs));
                this.setMessages(msgs);
                logger.finest("Ending execution of method - setReadout");
                break;
            }
            case FileCompliance: {
                double fileCompl = value.doubleValue();
                logger.finest(String.format("Setting fileCompliance to: %s.", fileCompl));
                this.setFileCompliance(fileCompl);
                logger.finest("Ending execution of method - setReadout");
                break;
            }
            default: {
                PrqaReadingException exception = new PrqaReadingException(String.format("Could not set value of %s for category %s in class %s", new Object[]{value, category, this.getClass()}));
                logger.severe(String.format("Exception thrown type: %s; message: %s", exception.getClass(), exception.getMessage()));
                throw exception;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Project Compliance Index : ");
        sb.append(this.getProjectCompliance() != null ? this.getProjectCompliance() : "N/A");
        sb.append("%" + System.getProperty("line.separator"));
        sb.append("File Compliance Index : ");
        sb.append(this.getFileCompliance() != null ? this.getFileCompliance() : "N/A");
        sb.append("%" + System.getProperty("line.separator"));
        sb.append("Diagnostic Count : ");
        sb.append(this.messages + System.getProperty("line.separator"));
        sb.append("Messages by group:\n");
        if (this.getMessagesGroups() != null && this.getMessagesGroups().size() > 0) {
            List<MessageGroup> messagesGroups = this.getMessagesGroups();
            for (MessageGroup messageGroup : messagesGroups) {
                sb.append(messageGroup.getMessageGroupName() + "\n");
                List<Rule> violatedRules = messageGroup.getViolatedRules();
                for (Rule violatedRule : violatedRules) {
                    sb.append(String.format("Rule %s messages (%s)%n", violatedRule.getRuleID(), violatedRule.getRuleTotalViolations()));
                }
            }
        }
        if (this.getMessagesByLevel() != null) {
            for (int i : this.getMessagesByLevel().keySet()) {
                sb.append(String.format("Rule %s messages (%s)%n", i, this.getMessagesByLevel().get(i)));
            }
        }
        if (this.notifications != null) {
            for (String note : this.notifications) {
                sb.append("Notify: " + note + System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(PRQAComplianceStatus o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        if (this.projectCompliance < o.getProjectCompliance() || this.fileCompliance < o.getProjectCompliance() || this.messages > o.getMessages()) {
            return -1;
        }
        if (this.projectCompliance > o.getProjectCompliance() || this.fileCompliance > o.getFileCompliance() || this.messages < o.getMessages()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isValid() {
        logger.finest("Starting execution of method - isValid");
        boolean result = this.fileCompliance != null && this.projectCompliance != null;
        logger.finest(String.format("Returning value: %s", result));
        return result;
    }

    @Override
    public String toHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table cellpadding=\"0\" style=\"border-style:none;margin:10px;border-collapse:collapse;border-spacing:0px\">");
        sb.append("<h2>Compliance Summary</h2>");
        sb.append("<thead>");
        sb.append("<tr>");
        sb.append("<th style=\"padding:10px 10px 0px;font-weight:700\">Messages within threshold</th>");
        sb.append("<th style=\"padding:10px 10px 0px;font-weight:700\">All messages</th>");
        sb.append("<th style=\"padding:10px 10px 0px;font-weight:700\">Project Compliance</th>");
        sb.append("<th style=\"padding:10px 10px 0px;font-weight:700\">File Compliance</th>");
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        sb.append("<tr>");
        sb.append("<td style=\"padding:10px;font-weight:400\">").append(this.getMessagesWithinThreshold()).append("</td>");
        sb.append("<td style=\"padding:10px;font-weight:400;\">").append(this.getMessages()).append("</td>");
        sb.append("<td style=\"padding:10px;font-weight:400;\">").append(this.getProjectCompliance() != null ? this.getProjectCompliance() : "N/A").append("%</td>");
        sb.append("<td style=\"padding:10px;;font-weight:400\">").append(this.getFileCompliance() != null ? this.getFileCompliance() : "N/A").append("%</td>");
        sb.append("</tr>");
        sb.append("</tbody>");
        sb.append("</table>");
        if (this.getMessagesGroups() != null && this.getMessagesGroups().size() > 0) {
            sb.append("<table cellpadding=\"0\" style=\"border-style:none;margin:10px;border-collapse:collapse\">");
            sb.append("<h2>Messages Summary</h2>");
            sb.append("<thead>");
            sb.append("<tr>");
            List<MessageGroup> messagesGroups = this.getMessagesGroups();
            for (MessageGroup messageGroup : messagesGroups) {
                sb.append("<th style=\"padding-right:5px;\">" + messageGroup.getMessageGroupName().trim() + ": </th>");
                sb.append("<th style=\"padding-right:5px;\">" + messageGroup.getTotalViolations() + "</th>");
                sb.append("</tr>");
                sb.append("</thead>");
                sb.append("<tbody>");
                List<Rule> violatedRules = messageGroup.getViolatedRules();
                int i = 0;
                for (Rule violatedRule : violatedRules) {
                    if (i % 2 == 0) {
                        sb.append(String.format("<tr><td style=\"background-color:#CCCCCC\">%s:Rule %s -> </td><td style=\"background-color:#CCCCCC\">%s</td></tr>", i, violatedRule.getRuleID(), violatedRule.getRuleTotalViolations()));
                    } else {
                        sb.append(String.format("<tr><td style=\"background-color:#FFFFFF\">%s:Rule %s -> </td><td style=\"background-color:#FFFFFF\">%s</td></tr>", i, violatedRule.getRuleID(), violatedRule.getRuleTotalViolations()));
                    }
                    ++i;
                }
            }
            sb.append("</tbody>");
            sb.append("</table>");
        } else if (this.getMessagesByLevel() != null && this.getMessagesByLevel().size() > 0) {
            sb.append("<table cellpadding=\"0\" style=\"border-style:none;margin:10px;border-collapse:collapse\">");
            sb.append("<h2>Messages Summary</h2>");
            sb.append("<thead>");
            sb.append("<tr>");
            sb.append("<th style=\"padding-right:5px;\">Level</th>");
            sb.append("<th style=\"padding-right:5px;\">Number of messages</th>");
            sb.append("</tr>");
            sb.append("</thead>");
            sb.append("<tbody>");
            for (int i : this.getMessagesByLevel().keySet()) {
                if (i % 2 == 0) {
                    sb.append(String.format("<tr><td style=\"background-color:#CCCCCC\">%s</td><td style=\"background-color:#CCCCCC\">%s</td></tr>", i, this.getMessagesByLevel().get(i)));
                    continue;
                }
                sb.append(String.format("<tr><td style=\"background-color:#FFFFFF\">%s</td><td style=\"background-color:#FFFFFF\">%s</td></tr>", i, this.getMessagesByLevel().get(i)));
            }
            sb.append("</tbody>");
            sb.append("</table>");
        }
        return sb.toString();
    }

    public int getMessagesWithinThreshold() {
        return this.messagesWithinThreshold;
    }

    public List<MessageGroup> getMessagesGroups() {
        return this.messagesGroups;
    }

    public void setMessagesGroups(List<MessageGroup> messagesGroups) {
        this.messagesGroups = messagesGroups;
    }

    public Map<Integer, Integer> getMessagesByLevel() {
        return this.messagesByLevel;
    }

    public int getMessageCount(int threshold) {
        int cnt = 0;
        Map<Integer, Integer> messagesByLevel = this.getMessagesByLevel();
        for (int i = threshold; i <= 9; ++i) {
            if (messagesByLevel == null || !messagesByLevel.containsKey(i)) continue;
            cnt += messagesByLevel.get(i).intValue();
        }
        return cnt;
    }

    public int getMessagesWithinThresholdCount(int thresholdLevel) {
        if (this.messagesGroups != null && !this.messagesGroups.isEmpty()) {
            int count = 0;
            for (MessageGroup messageGroup : this.messagesGroups) {
                count += messageGroup.getMessagesWithinThreshold();
            }
            this.messagesWithinThreshold = count;
        } else {
            this.messagesWithinThreshold = this.getMessageCount(thresholdLevel);
        }
        return this.messagesWithinThreshold;
    }

    public void setMessagesWithinThreshold(int messagesWithinThreshold) {
        this.messagesWithinThreshold = messagesWithinThreshold;
    }

    public void setMessagesWithinThresholdForEachMessageGroup(int thresholdLevel) {
        if (this.messagesGroups != null && !this.messagesGroups.isEmpty()) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (MessageGroup messageGroup : this.messagesGroups) {
                messageGroup.setMessagesWithinThreshold(thresholdLevel, map);
            }
            this.messagesWithinThreshold = Rule.calc(map);
        }
    }
}

