/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.parsers;

import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.praqma.prqa.parsers.MessageGroup;
import net.praqma.prqa.parsers.Rule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultsDataParser
implements Serializable {
    private String filePath;
    private int rootLevel = 1;

    public ResultsDataParser(String filePath) {
        this.filePath = filePath;
    }

    public List<MessageGroup> parseResultsData() throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(new FileInputStream(this.filePath));
        return this.beginFileParsing(document);
    }

    private Map<String, Integer> getMessages(Element node) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        NodeList nList = node.getElementsByTagName("Message");
        for (int i = 0; i < nList.getLength(); ++i) {
            Node message = nList.item(i);
            map.put(message.getAttributes().getNamedItem("guid").getNodeValue(), Integer.parseInt(message.getAttributes().getNamedItem("active").getNodeValue()));
        }
        return map;
    }

    private List<MessageGroup> beginFileParsing(Document document) throws Exception {
        ArrayList<MessageGroup> messagesGroups = new ArrayList<MessageGroup>();
        document.getDocumentElement().normalize();
        NodeList nList = document.getElementsByTagName("dataroot");
        for (int varDataRoot = 0; varDataRoot < nList.getLength(); ++varDataRoot) {
            Node node = nList.item(varDataRoot);
            if (node.getNodeType() != 1 || !node.getAttributes().getNamedItem("type").getNodeValue().equals("project")) continue;
            Element pElement = (Element)node;
            NodeList pNodeList = pElement.getElementsByTagName("tree");
            for (int varTree = 0; varTree < pNodeList.getLength(); ++varTree) {
                Node cNode = pNodeList.item(varTree);
                if (cNode.getNodeType() != 1 || !cNode.getAttributes().getNamedItem("type").getNodeValue().equals("rules")) continue;
                Element cElement = (Element)cNode;
                NodeList cNodeList = cElement.getElementsByTagName("RuleGroup");
                for (int varRGroup = 0; varRGroup < cNodeList.getLength(); ++varRGroup) {
                    Element ccNode = (Element)cNodeList.item(varRGroup);
                    MessageGroup messageGroup = new MessageGroup(ccNode.getAttributes().getNamedItem("name").getNodeValue());
                    NodeList ccNodeList = ccNode.getChildNodes();
                    for (int varRule = 0; varRule < ccNodeList.getLength(); ++varRule) {
                        Element cccNode;
                        if (ccNodeList.item(varRule).getNodeType() != 1 || !"Rule".equals((cccNode = (Element)ccNodeList.item(varRule)).getTagName())) continue;
                        Rule violatedRule = new Rule(cccNode.getAttributes().getNamedItem("id").getNodeValue(), this.getMessages(cccNode));
                        messageGroup.addViolatedRule(violatedRule);
                    }
                    messagesGroups.add(messageGroup);
                }
            }
        }
        return messagesGroups;
    }
}

