/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;
import net.praqma.prqa.PRQAReading;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.status.StatusCategory;

public class PRQAStatusCollection
extends ArrayList<PRQAReading>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<StatusCategory, Number> overrideMinimum = new EnumMap<StatusCategory, Number>(StatusCategory.class);
    private Map<StatusCategory, Number> overrideMaximum = new EnumMap<StatusCategory, Number>(StatusCategory.class);
    private static final Logger logger = Logger.getLogger(PRQAStatusCollection.class.getName());

    public PRQAStatusCollection() {
        this(new ArrayList<PRQAReading>());
    }

    public PRQAStatusCollection(ArrayList<PRQAReading> collection) {
        logger.finest("Constructor called for class PRQAStatusCollection(ArrayList<PRQAReading> collection)");
        for (PRQAReading e : collection) {
            logger.finest(String.format("    %s", e));
        }
        this.addAll(collection);
    }

    public PRQAStatusCollection(PRQAStatusCollection collection) {
        logger.finest("Constructor called for class PRQAStatusCollection(PRQAStatusCollection collection)");
        for (PRQAReading e : collection) {
            logger.finest(String.format("    %s", e));
        }
        this.addAll(collection);
    }

    public final Number getMax(StatusCategory category) throws PrqaException {
        logger.finest("Starting execution of method - getMax");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        if (this.getOverriddenMax(category) != null) {
            Number output = this.getOverriddenMax(category);
            logger.finest(String.format("Returning overridden max for StatusCategory %s, value: %s", new Object[]{category, output}));
            return output;
        }
        int max = Integer.MIN_VALUE;
        int tmp = 0;
        logger.finest(String.format("Searching for maximum value for StatusCategory %s...", new Object[]{category}));
        for (PRQAReading s : this) {
            try {
                tmp = s.getReadout(category) == null ? 0 : s.getReadout(category).intValue();
            }
            catch (PrqaException iex) {
                logger.severe(String.format("Exception thrown type: %s; message: %s", iex.getClass(), iex.getMessage()));
                throw iex;
            }
            if (tmp < max) continue;
            max = tmp;
        }
        logger.finest(String.format("Returning max from StatusCategory %s, value: %s", new Object[]{category, max}));
        return max;
    }

    public final Number getMin(StatusCategory category) throws PrqaException {
        logger.finest("Starting execution of method - getMin");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        if (this.getOverriddenMin(category) != null) {
            Number output = this.getOverriddenMin(category);
            logger.finest(String.format("Returning overridden min for StatusCategory %s, value: %s", new Object[]{category, output}));
            return output;
        }
        int min = Integer.MAX_VALUE;
        int tmp = 0;
        logger.finest(String.format("Searching for minimum value for StatusCategory %s...", new Object[]{category}));
        for (PRQAReading s : this) {
            try {
                tmp = s.getReadout(category) == null ? 0 : s.getReadout(category).intValue();
            }
            catch (PrqaException iex) {
                logger.severe(String.format("Exception thrown type: %s; message: %s", iex.getClass(), iex.getMessage()));
                throw iex;
            }
            if (tmp > min) continue;
            min = tmp;
        }
        logger.finest(String.format("Returning min from StatusCategory %s, value: %s", new Object[]{category, min}));
        return min;
    }

    public void overrideMin(StatusCategory category, Number value) {
        logger.finest("Starting execution of method - overrideMin");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        logger.finest(String.format("Input parameter value type: %s; value: %s", value.getClass(), value));
        this.overrideMinimum.put(category, value);
    }

    public void overrideMax(StatusCategory category, Number value) {
        logger.finest("Starting execution of method - overrideMax");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        logger.finest(String.format("Input parameter value type: %s; value: %s", value.getClass(), value));
        this.overrideMaximum.put(category, value);
    }

    public Number getOverriddenMax(StatusCategory category) {
        logger.finest("Starting execution of method - getOverriddenMax");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        if (this.overrideMaximum.containsKey((Object)category)) {
            Number output = this.overrideMaximum.get((Object)category);
            logger.finest(String.format("Returning overridden max for StatusCategory %s, value: %s", new Object[]{category, output}));
            return output;
        }
        logger.finest(String.format("Maximum for StatusCategory %s isn't set, returning null", new Object[]{category}));
        return null;
    }

    public Number getOverriddenMin(StatusCategory category) {
        logger.finest("Starting execution of method - getOverriddenMin");
        logger.finest(String.format("Input parameter category type: %s; value: %s", new Object[]{((Object)((Object)category)).getClass(), category}));
        if (this.overrideMinimum.containsKey((Object)category)) {
            Number output = this.overrideMinimum.get((Object)category);
            logger.finest(String.format("Returning overridden min for StatusCategory %s, value: %s", new Object[]{category, output}));
            return output;
        }
        logger.finest(String.format("Maximum for StatusCategory %s isn't set, returning null", new Object[]{category}));
        return null;
    }

    public final void clearOverrides() {
        logger.finest("Starting execution of method - clearOverrides");
        this.overrideMaximum.clear();
        this.overrideMinimum.clear();
        logger.finest("Overrides cleared.");
    }
}

