/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.threshold;

import hudson.Extension;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.jenkins.plugin.prqa.threshold.AbstractThreshold;
import net.praqma.prqa.status.PRQAComplianceStatus;
import org.kohsuke.stapler.DataBoundConstructor;

public class ProjectComplianceThreshold
extends AbstractThreshold {
    public final Double value;

    @DataBoundConstructor
    public ProjectComplianceThreshold(Double value, Boolean improvement) {
        super(improvement);
        this.value = value;
    }

    @Override
    public boolean validateImprovement(PRQAComplianceStatus previousComplianceStatus, PRQAComplianceStatus currentComplianceStatus) {
        boolean isValidImprovement = true;
        if (previousComplianceStatus != null) {
            boolean bl = isValidImprovement = currentComplianceStatus.getProjectCompliance() >= previousComplianceStatus.getProjectCompliance();
            if (!isValidImprovement) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentComplianceStatus.getProjectCompliance(), previousComplianceStatus.getProjectCompliance()));
            }
        }
        return isValidImprovement;
    }

    @Override
    public boolean validateThreshold(PRQAComplianceStatus currentComplianceStatus) {
        boolean isValidTreshold = true;
        if (this.value != null) {
            boolean bl = isValidTreshold = currentComplianceStatus.getProjectCompliance() >= this.value;
            if (!isValidTreshold) {
                currentComplianceStatus.addNotification(Messages.PRQANotifier_ProjectComplianceIndexRequirementNotMet(currentComplianceStatus.getProjectCompliance(), this.value));
            }
        }
        return isValidTreshold;
    }

    @Extension
    public static final class DescriptorImpl
    extends ThresholdSelectionDescriptor<ProjectComplianceThreshold> {
        public String getDisplayName() {
            return "Project Compliance Threshold";
        }

        public String getHelpFile() {
            return "/plugin/prqa-plugin/config/help-thresholds-project.html";
        }
    }
}

