/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.graphs;

import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.prqa.PRQAContext;
import net.praqma.prqa.PRQAStatusCollection;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.status.StatusCategory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class PRQAGraph
implements Serializable {
    protected List<StatusCategory> categories;
    protected PRQAStatusCollection data = new PRQAStatusCollection();
    protected String title;
    protected PRQAContext.QARReportType type;
    private static final Logger log = Logger.getLogger(PRQAGraph.class.getName());

    public PRQAContext.QARReportType getType() {
        return this.type;
    }

    public void setType(PRQAContext.QARReportType type) {
        this.type = type;
    }

    public List<StatusCategory> getCategories() {
        return this.categories;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setData(PRQAStatusCollection data) {
        this.data = data;
    }

    public PRQAStatusCollection getData() {
        return this.data;
    }

    public boolean containsStatus(StatusCategory cat) {
        return this.categories.contains((Object)cat);
    }

    public void drawGraph(StaplerRequest req, StaplerResponse rsp, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dsb, Double thresholdMax) throws IOException {
        try {
            Number max = null;
            Number min = null;
            int width = Integer.parseInt(req.getParameter("width"));
            int height = Integer.parseInt(req.getParameter("height"));
            int tsetting = Integer.parseInt(req.getParameter("tsetting"));
            for (StatusCategory category : this.categories) {
                try {
                    max = this.data.getMax(category);
                    min = this.data.getMin(category);
                }
                catch (PrqaException iex) {
                    continue;
                }
                if (category.equals((Object)StatusCategory.Messages)) {
                    if (tsetting == 0) {
                        this.setTitle("Messages per Build");
                    } else if (tsetting == 9) {
                        this.setTitle("Level 9 Messages per Build");
                    } else {
                        this.setTitle(String.format("Level %s-9 Messages per Build", tsetting));
                    }
                }
                log.fine("Iterating using category: " + (Object)((Object)category));
                if (max == null || min == null) continue;
                final JFreeChart chart = this.createChart(dsb.build(), this.getTitle() == null ? category.toString() : this.getTitle(), null, thresholdMax != null ? thresholdMax.intValue() : max.intValue(), min.intValue());
                new Graph(-1L, width, height){

                    protected JFreeChart createGraph() {
                        return chart;
                    }
                }.doPng(req, rsp);
            }
        }
        catch (RuntimeException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "drawGraph", "Failed to draw a graph", ex);
            throw ex;
        }
    }

    protected JFreeChart createChart(CategoryDataset dataset, String title, String yaxis, int max, int min) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.BOTTOM);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound((double)min);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public PRQAGraph(String title, PRQAContext.QARReportType type, StatusCategory ... category) {
        this.categories = new ArrayList<StatusCategory>();
        this.categories.addAll(Arrays.asList(category));
        this.type = type;
        this.title = title;
    }
}

