/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.OSDetector;
import com.profesorfalken.jpowershell.PowerShellCodepage;
import com.profesorfalken.jpowershell.PowerShellCommandProcessor;
import com.profesorfalken.jpowershell.PowerShellConfig;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PowerShell
implements AutoCloseable {
    private Process p;
    private PrintWriter commandWriter;
    private boolean closed = false;
    private ExecutorService threadpool;
    private static final String DEFAULT_WIN_EXECUTABLE = "powershell.exe";
    private static final String DEFAULT_LINUX_EXECUTABLE = "powershell";
    private int maxThreads = 3;
    private int waitPause = 10;
    private long maxWait = 10000L;
    private boolean remoteMode = false;
    private boolean scriptMode = false;
    public static final String END_SCRIPT_STRING = "--END-JPOWERSHELL-SCRIPT--";

    private PowerShell() {
    }

    public PowerShell configuration(Map<String, String> config) {
        try {
            this.maxThreads = Integer.valueOf(config != null && config.get("maxThreads") != null ? config.get("maxThreads") : PowerShellConfig.getConfig().getProperty("maxThreads"));
            this.waitPause = Integer.valueOf(config != null && config.get("waitPause") != null ? config.get("waitPause") : PowerShellConfig.getConfig().getProperty("waitPause"));
            this.maxWait = Long.valueOf(config != null && config.get("maxWait") != null ? config.get("maxWait") : PowerShellConfig.getConfig().getProperty("maxWait"));
            this.remoteMode = Boolean.valueOf(config != null && config.get("remoteMode") != null ? config.get("remoteMode") : PowerShellConfig.getConfig().getProperty("remoteMode"));
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Could not read configuration. Use default values.", nfe);
        }
        return this;
    }

    private PowerShell initalize(String customPowerShellExecutablePath) throws PowerShellNotAvailableException {
        String powerShellExecutable;
        String codePage = PowerShellCodepage.getIdentifierByCodePageName(Charset.defaultCharset().name());
        ProcessBuilder pb = null;
        if (OSDetector.isWindows()) {
            powerShellExecutable = customPowerShellExecutablePath == null ? DEFAULT_WIN_EXECUTABLE : customPowerShellExecutablePath;
            pb = new ProcessBuilder("cmd.exe", "/c", "chcp", codePage, ">", "NUL", "&", powerShellExecutable, "-ExecutionPolicy", "Bypass", "-NoExit", "-Command", "-");
        } else {
            powerShellExecutable = customPowerShellExecutablePath == null ? DEFAULT_LINUX_EXECUTABLE : customPowerShellExecutablePath;
            pb = new ProcessBuilder(powerShellExecutable, "-nologo", "-noexit", "-Command", "-");
        }
        try {
            this.p = pb.start();
            if (!this.p.isAlive()) {
                throw new PowerShellNotAvailableException("Cannot execute PowerShell. Please make sure that it is installed in your system. Errorcode:" + this.p.exitValue());
            }
        }
        catch (IOException ex) {
            throw new PowerShellNotAvailableException("Cannot execute PowerShell. Please make sure that it is installed in your system", ex);
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        this.threadpool = Executors.newFixedThreadPool(this.maxThreads);
        return this;
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        return PowerShell.openSession(null);
    }

    public static PowerShell openSession(String customPowerShellExecutablePath) throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        powerShell.configuration(null);
        String powerShellExecutablePath = customPowerShellExecutablePath == null ? (OSDetector.isWindows() ? DEFAULT_WIN_EXECUTABLE : DEFAULT_LINUX_EXECUTABLE) : customPowerShellExecutablePath;
        return powerShell.initalize(powerShellExecutablePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerShellResponse executeCommand(String command) {
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor("standard", this.p.getInputStream(), this.maxWait, this.waitPause, this.scriptMode);
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor("error", this.p.getErrorStream(), this.maxWait + (long)this.waitPause + 100L, this.waitPause, false);
        String commandOutput = "";
        boolean isError = false;
        boolean timeout = false;
        Future<String> result = this.threadpool.submit(commandProcessor);
        Future<String> resultError = this.threadpool.submit(commandProcessorError);
        if (this.remoteMode) {
            command = this.completeRemoteCommand(command);
        }
        this.commandWriter.println(command);
        try {
            while (!result.isDone() && !resultError.isDone()) {
                Thread.sleep(this.waitPause);
            }
            if (result.isDone()) {
                if (commandProcessor.isTimeout()) {
                    timeout = true;
                } else {
                    commandOutput = result.get();
                }
            } else {
                isError = true;
                commandOutput = resultError.get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        finally {
            commandProcessor.close();
            commandProcessorError.close();
        }
        return new PowerShellResponse(isError, commandOutput, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerShellResponse executeSingleCommand(String command) {
        PowerShellResponse response = null;
        try (PowerShell session = null;){
            session = PowerShell.openSession();
            response = session.executeCommand(command);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createWriteTempFile(BufferedReader srcReader) {
        BufferedWriter tmpWriter = null;
        File tmpFile = null;
        try {
            String line;
            tmpFile = File.createTempFile("psscript_" + new Date().getTime(), ".ps1");
            if (!tmpFile.exists()) {
                File file = null;
                return file;
            }
            tmpWriter = new BufferedWriter(new FileWriter(tmpFile));
            while (srcReader != null && (line = srcReader.readLine()) != null) {
                tmpWriter.write(line);
                tmpWriter.newLine();
            }
            tmpWriter.write("Write-Output \"--END-JPOWERSHELL-SCRIPT--\"");
        }
        catch (IOException ioex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error while writing temporary PowerShell script", ioex);
        }
        finally {
            try {
                if (srcReader != null) {
                    srcReader.close();
                }
                if (tmpWriter != null) {
                    tmpWriter.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing temporary PowerShell script", ex);
            }
        }
        return tmpFile;
    }

    public PowerShellResponse executeScript(String scriptPath) {
        return this.executeScript(scriptPath, "");
    }

    public PowerShellResponse executeScript(String scriptPath, String params) {
        BufferedReader srcReader = null;
        File scriptToExecute = new File(scriptPath);
        if (!scriptToExecute.exists()) {
            return new PowerShellResponse(true, "Wrong script path: " + scriptToExecute, false);
        }
        try {
            srcReader = new BufferedReader(new FileReader(scriptToExecute));
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell script: file not found", fnfex);
        }
        return this.executeScript(srcReader, params);
    }

    public PowerShellResponse executeScript(BufferedReader srcReader) {
        return this.executeScript(srcReader, "");
    }

    public PowerShellResponse executeScript(BufferedReader srcReader, String params) {
        if (srcReader != null) {
            File tmpFile = this.createWriteTempFile(srcReader);
            if (tmpFile != null) {
                this.scriptMode = true;
                return this.executeCommand(tmpFile.getAbsolutePath() + " " + params);
            }
            return new PowerShellResponse(true, "Cannot create temp script file!", false);
        }
        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Script buffered reader is null!");
        return new PowerShellResponse(true, "Script buffered reader is null!", false);
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                Future<String> closeTask = this.threadpool.submit(() -> {
                    this.commandWriter.println("exit");
                    this.p.waitFor();
                    return "OK";
                });
                this.waitUntilClose(closeTask);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing PowerShell", ex);
            }
            finally {
                try {
                    this.p.getInputStream().close();
                    this.p.getErrorStream().close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex);
                }
                this.commandWriter.close();
                if (this.threadpool != null) {
                    try {
                        this.threadpool.shutdownNow();
                        this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex);
                    }
                }
                this.closed = true;
            }
        }
    }

    private void waitUntilClose(Future<String> task) throws InterruptedException {
        int closingTime = 0;
        while (!task.isDone()) {
            if ((long)closingTime > this.maxWait) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when closing PowerShell: TIMEOUT!");
                break;
            }
            Thread.sleep(this.waitPause);
            closingTime += this.waitPause;
        }
    }

    private String completeRemoteCommand(String command) {
        return command + ";Write-Output \"\"";
    }
}

