/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

class PowerShellCommandProcessor
implements Callable {
    private static final String CRLF = "\r\n";
    private final BufferedReader reader;
    private final String name;
    private boolean closed = false;

    public PowerShellCommandProcessor(String name, PrintWriter commandWriter, InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.name = name;
    }

    public String call() throws IOException, InterruptedException {
        StringBuilder powerShellOutput = new StringBuilder();
        if (this.startReading()) {
            String line;
            while (null != (line = this.reader.readLine())) {
                powerShellOutput.append(line).append(CRLF);
                try {
                    if (this.continueReading() && !this.closed) continue;
                    break;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(PowerShellCommandProcessor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return powerShellOutput.toString();
    }

    private boolean startReading() throws IOException, InterruptedException {
        int timeWaiting = 0;
        while (!this.reader.ready()) {
            Thread.sleep(10L);
            if ((timeWaiting += 10) <= 5000 && !this.closed) continue;
            return false;
        }
        return true;
    }

    private boolean continueReading() throws IOException, InterruptedException {
        Thread.sleep(10L);
        return this.reader.ready();
    }

    public void close() {
        this.closed = true;
    }

    public String getName() {
        return this.name;
    }
}

