/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.wmi4java;

import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import com.profesorfalken.wmi4java.WMIException;
import com.profesorfalken.wmi4java.WMIStub;

class WMIPowerShell
implements WMIStub {
    WMIPowerShell() {
    }

    private String executeCommand(String command) throws WMIException {
        String commandResponse = null;
        PowerShell powerShell = null;
        try {
            powerShell = PowerShell.openSession();
            PowerShellResponse psResponse = powerShell.executeCommand(command);
            if (psResponse.isError()) {
                throw new WMIException("WMI operation finished in error: " + psResponse.getCommandOutput());
            }
            commandResponse = psResponse.getCommandOutput();
            powerShell.close();
        }
        catch (PowerShellNotAvailableException ex) {
            throw new WMIException(ex.getMessage(), ex);
        }
        finally {
            if (powerShell != null) {
                powerShell.close();
            }
        }
        return commandResponse;
    }

    public String listClasses(String namespace, String computerName) throws WMIException {
        String namespaceString = "";
        if (!"*".equals(namespace)) {
            namespaceString = namespaceString + "-Namespace " + namespace;
        }
        return this.executeCommand("Get-WMIObject " + namespaceString + " -List | Sort Name");
    }

    public String listProperties(String wmiClass, String namespace, String computerName) throws WMIException {
        String command = "Get-WMIObject " + wmiClass + " ";
        if (!"*".equals(namespace)) {
            command = command + "-Namespace " + namespace;
        }
        command = command + " | ";
        command = command + "Select-Object * -excludeproperty \"_*\" | ";
        command = command + "Get-Member | select name | format-table -hidetableheader";
        return this.executeCommand(command);
    }

    public String listObject(String wmiClass, String namespace, String computerName) throws WMIException {
        String command = "Get-WMIObject " + wmiClass + " ";
        if (!"*".equals(namespace)) {
            command = command + "-Namespace " + namespace;
        }
        command = command + " | ";
        command = command + "Select-Object * -excludeproperty \"_*\" | ";
        command = command + "Format-List *";
        return this.executeCommand(command);
    }
}

