/*
 * Decompiled with CFR 0.152.
 */
package com.postmarkapp.postmark.client;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Parameters {
    private final HashMap<String, String> parameters = new HashMap();

    public static Parameters init() {
        return new Parameters();
    }

    public Parameters build(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public Parameters build(String name, Boolean value) {
        this.parameters.put(name, value.toString());
        return this;
    }

    public Parameters build(String name, Integer value) {
        return this.build(name, value.toString());
    }

    public Parameters build(String name, Date value) {
        this.parameters.put(name, new SimpleDateFormat("yyyy-MM-dd").format(value));
        return this;
    }

    public String toString() {
        StringBuilder parameterString = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            parameterString.append(count == 0 ? "?" : "&");
            parameterString.append(entry.getKey());
            parameterString.append("=");
            parameterString.append(entry.getValue());
            ++count;
        }
        return parameterString.toString();
    }
}

