/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.multipartycall;

import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.VoiceUpdater;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantUpdateResponse;
import com.plivo.api.models.multipartycall.MultiPartyCallUtils;
import com.plivo.api.util.Utils;
import retrofit2.Call;

public class MultiPartyCallParticipantUpdate
extends VoiceUpdater<MultiPartyCallParticipantUpdateResponse> {
    private Boolean mute;
    private Boolean hold;
    private Boolean coachMode;

    public MultiPartyCallParticipantUpdate(String mpcId, String secondaryId) {
        super(mpcId, secondaryId);
    }

    public Boolean mute() {
        return this.mute;
    }

    public Boolean hold() {
        return this.hold;
    }

    public Boolean coachMode() {
        return this.coachMode;
    }

    public MultiPartyCallParticipantUpdate mute(Boolean mute) {
        this.mute = mute;
        return this;
    }

    public MultiPartyCallParticipantUpdate hold(Boolean hold) {
        this.hold = hold;
        return this;
    }

    public MultiPartyCallParticipantUpdate coachMode(Boolean coachMode) {
        this.coachMode = coachMode;
        return this;
    }

    @Override
    protected Call<MultiPartyCallParticipantUpdateResponse> obtainCall() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        if (this.secondaryId.equalsIgnoreCase("all") && this.coachMode != null) {
            throw new PlivoValidationException("cannot update coachMode for all participants");
        }
        if (!Utils.anyNotNull(this.coachMode, this.mute, this.hold)) {
            throw new PlivoValidationException("please update either mute, hold or coach_mode");
        }
        return this.client().getVoiceApiService().mpcMemberUpdate(this.client().getAuthId(), this.id, this.secondaryId, this);
    }

    @Override
    protected Call<MultiPartyCallParticipantUpdateResponse> obtainFallback1Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        if (this.secondaryId.equalsIgnoreCase("all") && this.coachMode != null) {
            throw new PlivoValidationException("cannot update coachMode for all participants");
        }
        if (!Utils.anyNotNull(this.coachMode, this.mute, this.hold)) {
            throw new PlivoValidationException("please update either mute, hold or coach_mode");
        }
        return this.client().getVoiceFallback1Service().mpcMemberUpdate(this.client().getAuthId(), this.id, this.secondaryId, this);
    }

    @Override
    protected Call<MultiPartyCallParticipantUpdateResponse> obtainFallback2Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.id);
        if (this.secondaryId.equalsIgnoreCase("all") && this.coachMode != null) {
            throw new PlivoValidationException("cannot update coachMode for all participants");
        }
        if (!Utils.anyNotNull(this.coachMode, this.mute, this.hold)) {
            throw new PlivoValidationException("please update either mute, hold or coach_mode");
        }
        return this.client().getVoiceFallback2Service().mpcMemberUpdate(this.client().getAuthId(), this.id, this.secondaryId, this);
    }
}

