/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.multipartycall;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.ListResponse;
import com.plivo.api.models.base.VoiceLister;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipant;
import com.plivo.api.models.multipartycall.MultiPartyCallUtils;
import retrofit2.Call;

public class MultiPartyCallParticipantList
extends VoiceLister<MultiPartyCallParticipant> {
    @JsonIgnore
    private final String mpcId;
    private String callUuid;

    public MultiPartyCallParticipantList(String mpcId) {
        this.mpcId = mpcId;
    }

    public String callUuid() {
        return this.callUuid;
    }

    public MultiPartyCallParticipantList callUuid(String callUuid) {
        this.callUuid = callUuid;
        return this;
    }

    @Override
    protected Call<ListResponse<MultiPartyCallParticipant>> obtainCall() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.mpcId);
        return this.client().getVoiceApiService().mpcListParticipants(this.client().getAuthId(), this.mpcId, this.toMap());
    }

    @Override
    protected Call<ListResponse<MultiPartyCallParticipant>> obtainFallback1Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.mpcId);
        return this.client().getVoiceFallback1Service().mpcListParticipants(this.client().getAuthId(), this.mpcId, this.toMap());
    }

    @Override
    protected Call<ListResponse<MultiPartyCallParticipant>> obtainFallback2Call() throws PlivoValidationException {
        MultiPartyCallUtils.validMultiPartyCallId(this.mpcId);
        return this.client().getVoiceFallback2Service().mpcListParticipants(this.client().getAuthId(), this.mpcId, this.toMap());
    }
}

