/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.multipartycall;

import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseResponse;
import com.plivo.api.models.base.SecondaryResource;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantGet;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantKick;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingPause;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingResume;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingStart;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantRecordingStop;
import com.plivo.api.models.multipartycall.MultiPartyCallParticipantUpdate;
import com.plivo.api.models.multipartycall.MultiPartyCallUtils;
import java.io.IOException;

public class MultiPartyCallParticipant
extends SecondaryResource {
    private String billedAmount;
    private Long billedDuration;
    private String callUuid;
    private Boolean coachMode;
    private Long duration;
    private Boolean endMpcOnExit;
    private String exitCause;
    private String exitTime;
    private Boolean hold;
    private String joinTime;
    private String memberId;
    private String memberAddress;
    private String mpcUuid;
    private Boolean mute;
    private String resourceUri;
    private String role;
    private Boolean startMpcOnEnter;

    public static MultiPartyCallParticipantGet getter(String mpcId, String participantId) {
        return new MultiPartyCallParticipantGet(mpcId, participantId);
    }

    public MultiPartyCallParticipant get() throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallParticipantGet getter = new MultiPartyCallParticipantGet(this.getId(), this.getSecondaryId());
        return (MultiPartyCallParticipant)getter.get();
    }

    public static MultiPartyCallParticipantUpdate updater(String mpcId, String participantId) {
        return new MultiPartyCallParticipantUpdate(mpcId, participantId);
    }

    public MultiPartyCallParticipantUpdate update() throws PlivoValidationException {
        return new MultiPartyCallParticipantUpdate(this.getId(), this.getSecondaryId());
    }

    public static MultiPartyCallParticipantKick kicker(String mpcId, String participantId) {
        return new MultiPartyCallParticipantKick(mpcId, participantId);
    }

    public void kick() throws PlivoRestException, IOException, PlivoValidationException {
        MultiPartyCallParticipantKick kicker = new MultiPartyCallParticipantKick(this.getId(), this.getSecondaryId());
        kicker.delete();
    }

    public static MultiPartyCallParticipantRecordingStart recordStarter(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingStart(mpcId, participantId);
    }

    public MultiPartyCallParticipantRecordingStart recordStarter(String participantId) throws PlivoValidationException {
        return new MultiPartyCallParticipantRecordingStart(this.getId(), this.getSecondaryId());
    }

    public static MultiPartyCallParticipantRecordingStop recordStopper(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingStop(mpcId, participantId);
    }

    public void recordStop(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        MultiPartyCallParticipantRecordingStop recordStopper = new MultiPartyCallParticipantRecordingStop(this.getId(), this.getSecondaryId());
        recordStopper.delete();
    }

    public static MultiPartyCallParticipantRecordingPause recordPause(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingPause(mpcId, participantId);
    }

    public BaseResponse recordPause(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallParticipantRecordingPause(this.getId(), this.getSecondaryId()).update();
    }

    public static MultiPartyCallParticipantRecordingResume recordResume(String mpcId, String participantId) {
        return new MultiPartyCallParticipantRecordingResume(mpcId, participantId);
    }

    public BaseResponse recordResume(String participantId) throws IOException, PlivoRestException, PlivoValidationException {
        return new MultiPartyCallParticipantRecordingPause(this.getId(), this.getSecondaryId()).update();
    }

    public String getBilledAmount() {
        return this.billedAmount;
    }

    public Long getBilledDuration() {
        return this.billedDuration;
    }

    public String getCallUuid() {
        return this.callUuid;
    }

    public Boolean getCoachMode() {
        return this.coachMode;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Boolean getEndMpcOnExit() {
        return this.endMpcOnExit;
    }

    public String getExitCause() {
        return this.exitCause;
    }

    public String getExitTime() {
        return this.exitTime;
    }

    public Boolean getHold() {
        return this.hold;
    }

    public String getJoinTime() {
        return this.joinTime;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getmemberAddress() {
        return this.memberAddress;
    }

    public String getMpcUuid() {
        return this.mpcUuid;
    }

    public Boolean getMute() {
        return this.mute;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getRole() {
        return this.role;
    }

    public Boolean getStartMpcOnEnter() {
        return this.startMpcOnEnter;
    }

    @Override
    public String getSecondaryId() {
        return this.getMemberId();
    }

    @Override
    public String getId() throws PlivoValidationException {
        return MultiPartyCallUtils.mpcUuid(this.getMpcUuid());
    }
}

