/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.conference;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.VoiceCreator;
import com.plivo.api.models.conference.ConferenceRecordCreateResponse;
import java.io.IOException;
import retrofit2.Call;

public class ConferenceRecordCreator
extends VoiceCreator<ConferenceRecordCreateResponse> {
    @JsonIgnore
    private final String conferenceName;
    private Integer timeLimit;
    private String fileFormat;
    private String transcriptionType;
    private String transcriptionUrl;
    private String transcriptionMethod;
    private String callbackUrl;
    private String callbackMethod;

    public ConferenceRecordCreator(String conferenceName) {
        this.conferenceName = conferenceName;
    }

    public Integer timeLimit() {
        return this.timeLimit;
    }

    public String fileFormat() {
        return this.fileFormat;
    }

    public String transcriptionType() {
        return this.transcriptionType;
    }

    public String transcriptionUrl() {
        return this.transcriptionUrl;
    }

    public String transcriptionMethod() {
        return this.transcriptionMethod;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String callbackMethod() {
        return this.callbackMethod;
    }

    public ConferenceRecordCreator timeLimit(Integer timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public ConferenceRecordCreator fileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    public ConferenceRecordCreator transcriptionType(String transcriptionType) {
        this.transcriptionType = transcriptionType;
        return this;
    }

    public ConferenceRecordCreator transcriptionUrl(String transcriptionUrl) {
        this.transcriptionUrl = transcriptionUrl;
        return this;
    }

    public ConferenceRecordCreator transcriptionMethod(String transcriptionMethod) {
        this.transcriptionMethod = transcriptionMethod;
        return this;
    }

    public ConferenceRecordCreator callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public ConferenceRecordCreator callbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    @Override
    protected Call<ConferenceRecordCreateResponse> obtainCall() {
        return this.client().getVoiceApiService().conferenceRecordCreate(this.client().getAuthId(), this.conferenceName);
    }

    @Override
    protected Call<ConferenceRecordCreateResponse> obtainFallback1Call() {
        return this.client().getVoiceFallback1Service().conferenceRecordCreate(this.client().getAuthId(), this.conferenceName);
    }

    @Override
    protected Call<ConferenceRecordCreateResponse> obtainFallback2Call() {
        return this.client().getVoiceFallback2Service().conferenceRecordCreate(this.client().getAuthId(), this.conferenceName);
    }

    public ConferenceRecordCreateResponse record() throws IOException, PlivoRestException {
        return (ConferenceRecordCreateResponse)this.create();
    }

    @Override
    public ConferenceRecordCreator client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }
}

