/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResponse;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class VoiceUpdater<T extends BaseResponse>
extends BaseRequest {
    @JsonIgnore
    protected String id;
    @JsonIgnore
    protected String secondaryId;

    public VoiceUpdater(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public VoiceUpdater(String id, String secondaryId) {
        if (id == null || secondaryId == null) {
            throw new IllegalArgumentException("id/secondaryId cannot be null");
        }
        this.id = id;
        this.secondaryId = secondaryId;
    }

    public T update() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        if (response.code() >= 500 && (response = this.obtainFallback1Call().execute()).code() >= 500) {
            response = this.obtainFallback2Call().execute();
        }
        this.handleResponse(response);
        return (T)((BaseResponse)response.body());
    }

    @Override
    public VoiceUpdater<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected abstract Call<T> obtainCall() throws PlivoValidationException;

    protected abstract Call<T> obtainFallback1Call() throws PlivoValidationException;

    protected abstract Call<T> obtainFallback2Call() throws PlivoValidationException;
}

