/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.util.Utils;
import java.io.IOException;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public abstract class VoiceGetter<T extends BaseResource>
extends BaseRequest<T> {
    protected final String id;
    protected String secondaryId;

    public VoiceGetter(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public VoiceGetter(String id, String secondaryId) {
        if (id == null || secondaryId == null) {
            throw new IllegalArgumentException("id/secondaryId cannot be null");
        }
        this.id = id;
        this.secondaryId = secondaryId;
    }

    public T get() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        if (response.code() >= 500 && (response = this.obtainFallback1Call().execute()).code() >= 500) {
            response = this.obtainFallback2Call().execute();
        }
        this.handleResponse(response);
        return (T)((BaseResource)response.body());
    }

    @Override
    public VoiceGetter<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected Map<String, Object> toMap() {
        this.client();
        return Utils.objectToMap(PlivoClient.getObjectMapper(), this);
    }

    protected abstract Call<T> obtainCall() throws PlivoValidationException;

    protected abstract Call<T> obtainFallback1Call() throws PlivoValidationException;

    protected abstract Call<T> obtainFallback2Call() throws PlivoValidationException;
}

