/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.plivo.api.PlivoClient;
import com.plivo.api.models.base.LogLevel;
import java.io.IOException;
import okhttp3.OkHttpClient;

public class PhloRestClient {
    protected static String BASE_URL = "https://phlorunner.plivo.com/v1/";
    private SimpleModule simpleModule = new SimpleModule();
    private final PlivoClient client;

    public PhloRestClient(String authId, String authToken) {
        this.simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new JsonDeserializer<Enum>(){

                    public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                        Class rawClass = type.getRawClass();
                        return Enum.valueOf(rawClass, jp.getValueAsString().toUpperCase().replace("-", "_"));
                    }
                };
            }
        });
        this.simpleModule.addSerializer(Enum.class, (JsonSerializer)new StdSerializer<Enum>(Enum.class){

            public void serialize(Enum value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.name().toLowerCase());
            }
        });
        this.client = new PlivoClient(authId, authToken, new OkHttpClient.Builder(), BASE_URL, this.simpleModule, LogLevel.NONE);
    }

    public PhloRestClient(String authId, String authToken, OkHttpClient.Builder httpClientBuilder) {
        this.simpleModule.setDeserializerModifier(new /* invalid duplicate definition of identical inner class */);
        this.simpleModule.addSerializer(Enum.class, (JsonSerializer)new /* invalid duplicate definition of identical inner class */);
        this.client = new PlivoClient(authId, authToken, httpClientBuilder, BASE_URL, this.simpleModule, LogLevel.NONE);
    }

    public PlivoClient getClient() {
        return this.client;
    }
}

