/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.toxiproxy;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.ToxiProxyProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.DynamicPropertyRegistrar;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnToxiProxyEnabled
@EnableConfigurationProperties(value={ToxiProxyProperties.class})
public class EmbeddedToxiProxyBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedToxiProxyBootstrapConfiguration.class);
    private static final String TOXIPROXY_NETWORK_ALIAS = "toxiproxy.testcontainer.docker";
    private static final String TOXIPROXY_NETWORK_ALIAS_OLD = "toxiproxy";

    @Bean
    @ConditionalOnMissingBean(value={Network.class})
    Network toxiproxyNetwork() {
        Network network = Network.newNetwork();
        log.info("Created docker Network with id={}", (Object)network.getId());
        return network;
    }

    @Bean(name={"toxiproxy"}, destroyMethod="stop")
    ToxiproxyContainer toxiproxy(ToxiProxyProperties toxiProxyProperties, Network network) {
        ToxiproxyContainer toxiproxyContainer = (ToxiproxyContainer)((ToxiproxyContainer)new ToxiproxyContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)toxiProxyProperties)).withNetwork(network)).withNetworkAliases(new String[]{TOXIPROXY_NETWORK_ALIAS, TOXIPROXY_NETWORK_ALIAS_OLD});
        toxiproxyContainer = (ToxiproxyContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)toxiproxyContainer, (CommonContainerProperties)toxiProxyProperties, (Logger)log);
        return toxiproxyContainer;
    }

    @Bean
    public DynamicPropertyRegistrar toxiproxyDynamicPropertyRegistrar(@Qualifier(value="toxiproxy") ToxiproxyContainer toxiproxy) {
        return registry -> {
            registry.add("embedded.toxiproxy.host", () -> ((ToxiproxyContainer)toxiproxy).getHost());
            registry.add("embedded.toxiproxy.controlPort", () -> ((ToxiproxyContainer)toxiproxy).getControlPort());
            registry.add("embedded.toxiproxy.networkAlias", () -> TOXIPROXY_NETWORK_ALIAS);
        };
    }

    @Bean
    ToxiproxyClient toxiproxyClient(ToxiproxyContainer toxiproxy) {
        return new ToxiproxyClient(toxiproxy.getHost(), toxiproxy.getControlPort());
    }
}

