/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.toxiproxy;

import com.playtika.testcontainer.toxiproxy.ToxiproxyClientProxy;
import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.ToxiproxyContainer;

public final class ToxiproxyHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ToxiproxyHelper.class);
    private static final int FIRST_PROXIED_PORT = 8666;
    private static final int LAST_PROXIED_PORT = 8866;
    private static final AtomicInteger nextPort = new AtomicInteger(8666);

    public static ToxiproxyClientProxy createProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, GenericContainer<?> targetContainer, int targetPort, String proxyName) {
        try {
            String upstream = ToxiproxyHelper.getUpstreamAddress(targetContainer, targetPort);
            int toxiPort = nextPort.getAndIncrement();
            if (toxiPort > 8866) {
                throw new IllegalStateException("Maximum number of proxies exceeded");
            }
            Proxy proxy = toxiproxyClient.createProxy(proxyName, "0.0.0.0:" + toxiPort, upstream);
            int mappedPort = toxiproxyContainer.getMappedPort(toxiPort);
            return new ToxiproxyClientProxy(proxy, toxiproxyContainer.getHost(), mappedPort);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create toxiproxy for " + proxyName, e);
        }
    }

    public static ToxiproxyClientProxy createProxy(ToxiproxyClient toxiproxyClient, ToxiproxyContainer toxiproxyContainer, String targetHostname, int targetPort, String proxyName) {
        try {
            String upstream = targetHostname + ":" + targetPort;
            int toxiPort = nextPort.getAndIncrement();
            if (toxiPort > 8866) {
                throw new IllegalStateException("Maximum number of proxies exceeded");
            }
            Proxy proxy = toxiproxyClient.createProxy(proxyName, "0.0.0.0:" + toxiPort, upstream);
            int mappedPort = toxiproxyContainer.getMappedPort(toxiPort);
            return new ToxiproxyClientProxy(proxy, toxiproxyContainer.getHost(), mappedPort);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create toxiproxy for " + proxyName, e);
        }
    }

    private static String getUpstreamAddress(GenericContainer<?> container, int port) {
        String alias;
        List networkAliases = container.getNetworkAliases();
        if (!networkAliases.isEmpty() && (alias = (String)networkAliases.get(0)) != null && !alias.isEmpty()) {
            return alias + ":" + port;
        }
        return container.getContainerInfo().getNetworkSettings().getNetworks().values().stream().findFirst().map(network -> network.getIpAddress() + ":" + port).orElseThrow(() -> new IllegalStateException("Cannot determine upstream address for container"));
    }

    public static void registerProxyEnvironment(ToxiproxyClientProxy proxy, String propertyPrefix, String propertySourceName, ConfigurableEnvironment environment) {
        ToxiproxyHelper.registerProxyEnvironment(proxy, propertyPrefix, propertySourceName, environment, "port");
    }

    public static void registerProxyEnvironment(ToxiproxyClientProxy proxy, String propertyPrefix, String propertySourceName, ConfigurableEnvironment environment, String portKey) {
        LinkedHashMap<CallSite, Object> map = new LinkedHashMap<CallSite, Object>();
        map.put((CallSite)((Object)(propertyPrefix + ".toxiproxy.host")), proxy.getContainerIpAddress());
        map.put((CallSite)((Object)(propertyPrefix + ".toxiproxy." + portKey)), proxy.getProxyPort());
        map.put((CallSite)((Object)(propertyPrefix + ".toxiproxy.proxyName")), proxy.getName());
        MapPropertySource propertySource = new MapPropertySource(propertySourceName, map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started {} ToxiProxy connection details {}", (Object)propertyPrefix, map);
    }

    @Generated
    private ToxiproxyHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

