/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import reactivefeign.webclient.WebReactiveOptions;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;
import reactor.netty.transport.ProxyProvider;

class NettyClientHttpConnectorBuilder {
    private static final Log LOG = LogFactory.getLog(NettyClientHttpConnectorBuilder.class);

    NettyClientHttpConnectorBuilder() {
    }

    public static ClientHttpConnector buildNettyClientHttpConnector(WebReactiveOptions webOptions) {
        TcpClient tcpClient = TcpClient.create();
        if (webOptions.getConnectTimeoutMillis() != null) {
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)webOptions.getConnectTimeoutMillis().intValue());
        }
        tcpClient = tcpClient.doOnConnected(connection -> {
            if (webOptions.getReadTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(webOptions.getReadTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
            if (webOptions.getWriteTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler(webOptions.getWriteTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
        });
        WebReactiveOptions.WebProxySettings proxySettings = (WebReactiveOptions.WebProxySettings)webOptions.getProxySettings();
        if (proxySettings != null) {
            tcpClient = tcpClient.proxy(typeSpec -> {
                ProxyProvider.Builder proxyBuilder = typeSpec.type(ProxyProvider.Proxy.HTTP).host(proxySettings.getHost()).port(proxySettings.getPort()).username(proxySettings.getUsername()).password(password -> proxySettings.getPassword());
                if (proxySettings.getTimeout() != null) {
                    proxyBuilder.connectTimeoutMillis(proxySettings.getTimeout().longValue());
                }
            });
        }
        HttpClient httpClient = HttpClient.from((TcpClient)tcpClient);
        if (webOptions.getResponseTimeoutMillis() != null) {
            httpClient = httpClient.responseTimeout(Duration.ofMillis(webOptions.getResponseTimeoutMillis()));
        }
        if (webOptions.isTryUseCompression() != null) {
            httpClient = httpClient.compress(true);
        }
        if (webOptions.isFollowRedirects() != null) {
            httpClient = httpClient.followRedirect(webOptions.isFollowRedirects().booleanValue());
        }
        if (Objects.equals(Boolean.TRUE, webOptions.isDisableSslValidation())) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                httpClient = httpClient.secure(sslProviderBuilder -> sslProviderBuilder.sslContext(sslContext));
            }
            catch (SSLException e) {
                LOG.warn((Object)"Error creating SSLContext. The WebClient will verify all new HTTPS calls", (Throwable)e);
            }
        }
        return new ReactorClientHttpConnector(httpClient);
    }
}

