/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class WebReactiveHttpResponse<P extends Publisher<?>>
implements ReactiveHttpResponse<P> {
    final ReactiveHttpRequest reactiveRequest;
    final ClientResponse clientResponse;
    final Type returnPublisherType;
    final ParameterizedTypeReference<?> returnActualType;

    WebReactiveHttpResponse(ReactiveHttpRequest reactiveRequest, ClientResponse clientResponse, Type returnPublisherType, ParameterizedTypeReference<?> returnActualType) {
        this.reactiveRequest = reactiveRequest;
        this.clientResponse = clientResponse;
        this.returnPublisherType = returnPublisherType;
        this.returnActualType = returnActualType;
    }

    public ReactiveHttpRequest request() {
        return this.reactiveRequest;
    }

    public int status() {
        return this.clientResponse.statusCode().value();
    }

    public Map<String, List<String>> headers() {
        return this.clientResponse.headers().asHttpHeaders();
    }

    public P body() {
        if (this.returnPublisherType == Mono.class) {
            return (P)this.clientResponse.bodyToMono(this.returnActualType);
        }
        if (this.returnPublisherType == Flux.class) {
            return (P)this.clientResponse.bodyToFlux(this.returnActualType);
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    public Mono<Void> releaseBody() {
        return this.clientResponse.releaseBody();
    }

    public Mono<byte[]> bodyData() {
        Flux response = (Flux)this.clientResponse.body(BodyExtractors.toDataBuffers());
        return DataBufferUtils.join((Publisher)response).map(WebReactiveHttpResponse::readToByteArray).defaultIfEmpty((Object)new byte[0]);
    }

    private static byte[] readToByteArray(DataBuffer dataBuffer) {
        byte[] result = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(result);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        return result;
    }
}

