/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilderFactory;
import reactivefeign.webclient.WebReactiveOptions;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;

public class CustomizableWebClientBuilder
implements WebClient.Builder {
    private static final Logger logger = LoggerFactory.getLogger(CustomizableWebClientBuilder.class);
    private String baseUrl;
    private Map<String, ?> defaultUriVariables;
    private UriBuilderFactory uriBuilderFactory;
    private Consumer<HttpHeaders> headersConsumer;
    private Map<String, String[]> headers = new HashMap<String, String[]>();
    private Consumer<MultiValueMap<String, String>> cookiesConsumer;
    private Map<String, String[]> cookies = new HashMap<String, String[]>();
    private Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    private Consumer<List<ExchangeFilterFunction>> filtersConsumer;
    private ExchangeStrategies strategies;
    private ExchangeFunction exchangeFunction;
    private ClientHttpConnector connector;
    private Consumer<WebClient.Builder> builderConsumer;
    private List<ExchangeFilterFunction> filters = new ArrayList<ExchangeFilterFunction>();
    private WebReactiveOptions webOptions = WebReactiveOptions.DEFAULT_OPTIONS;

    public WebClient.Builder baseUrl(String baseUrl) {
        if (this.baseUrl == null) {
            this.baseUrl = baseUrl;
        } else {
            logger.warn("Will ignore baseUrl parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        if (this.defaultUriVariables == null) {
            this.defaultUriVariables = defaultUriVariables;
        } else {
            logger.warn("Will ignore defaultUriVariables parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        if (this.uriBuilderFactory == null) {
            this.uriBuilderFactory = uriBuilderFactory;
        } else {
            logger.warn("Will ignore uriBuilderFactory parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultHeader(String header, String ... values) {
        if (this.headers.putIfAbsent(header, values) != null) {
            logger.warn("Will ignore header parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        if (this.headersConsumer == null) {
            this.headersConsumer = headersConsumer;
        } else {
            logger.warn("Will ignore headersConsumer parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultCookie(String cookie, String ... values) {
        if (this.cookies.putIfAbsent(cookie, values) != null) {
            logger.warn("Will ignore cookie parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        if (this.cookiesConsumer == null) {
            this.cookiesConsumer = cookiesConsumer;
        } else {
            logger.warn("Will ignore cookiesConsumer parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder defaultRequest(Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest) {
        if (this.defaultRequest == null) {
            this.defaultRequest = defaultRequest;
        } else {
            logger.warn("Will ignore defaultRequest parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder filter(ExchangeFilterFunction filter) {
        this.filters.add(filter);
        return this;
    }

    public WebClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        if (this.filtersConsumer == null) {
            this.filtersConsumer = filtersConsumer;
        } else {
            logger.warn("Will ignore filtersConsumer parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        if (this.connector == null) {
            this.connector = connector;
        } else {
            logger.warn("Will ignore connector parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        if (this.strategies == null) {
            this.strategies = strategies;
        } else {
            logger.warn("Will ignore strategies parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        if (this.exchangeFunction == null) {
            this.exchangeFunction = exchangeFunction;
        } else {
            logger.warn("Will ignore exchangeFunction parameter as it's already been set");
        }
        return this;
    }

    public WebClient.Builder clone() {
        throw new UnsupportedOperationException();
    }

    public WebClient.Builder apply(Consumer<WebClient.Builder> builderConsumer) {
        if (this.builderConsumer == null) {
            this.builderConsumer = builderConsumer;
        } else {
            logger.warn("Will ignore builderConsumer parameter as it's already been set");
        }
        return this;
    }

    public void setWebOptions(WebReactiveOptions webOptions) {
        this.webOptions = webOptions;
    }

    public WebClient build() {
        WebClient.Builder builder = WebClient.builder();
        if (this.baseUrl != null) {
            builder = builder.baseUrl(this.baseUrl);
        }
        if (this.defaultUriVariables != null) {
            builder = builder.defaultUriVariables(this.defaultUriVariables);
        }
        if (this.uriBuilderFactory != null) {
            builder = builder.uriBuilderFactory(this.uriBuilderFactory);
        }
        if (this.headersConsumer != null) {
            builder = builder.defaultHeaders(this.headersConsumer);
        }
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            builder = builder.defaultHeader(entry.getKey(), entry.getValue());
        }
        if (this.cookiesConsumer != null) {
            builder = builder.defaultCookies(this.cookiesConsumer);
        }
        for (Map.Entry<String, String[]> entry : this.cookies.entrySet()) {
            builder = builder.defaultCookie(entry.getKey(), entry.getValue());
        }
        if (this.defaultRequest != null) {
            builder = builder.defaultRequest(this.defaultRequest);
        }
        if (this.filtersConsumer != null) {
            builder = builder.filters(this.filtersConsumer);
        }
        for (ExchangeFilterFunction filter : this.filters) {
            builder = builder.filter(filter);
        }
        if (this.strategies != null) {
            builder = builder.exchangeStrategies(this.strategies);
        }
        if (this.exchangeFunction != null) {
            builder = builder.exchangeFunction(this.exchangeFunction);
        }
        builder = this.connector != null ? builder.clientConnector(this.connector) : builder.clientConnector((ClientHttpConnector)CustomizableWebClientBuilder.getReactorClientHttpConnector(this.webOptions));
        if (this.builderConsumer != null) {
            builder = builder.apply(this.builderConsumer);
        }
        return builder.build();
    }

    public static ReactorClientHttpConnector getReactorClientHttpConnector(WebReactiveOptions webOptions) {
        TcpClient tcpClient = TcpClient.create();
        if (webOptions.getConnectTimeoutMillis() != null) {
            tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)webOptions.getConnectTimeoutMillis().intValue());
        }
        tcpClient = tcpClient.doOnConnected(connection -> {
            if (webOptions.getReadTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(webOptions.getReadTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
            if (webOptions.getWriteTimeoutMillis() != null) {
                connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler(webOptions.getWriteTimeoutMillis().longValue(), TimeUnit.MILLISECONDS));
            }
        });
        HttpClient httpClient = HttpClient.from((TcpClient)tcpClient);
        if (webOptions.isTryUseCompression() != null) {
            httpClient = httpClient.compress(true);
        }
        return new ReactorClientHttpConnector(httpClient);
    }
}

