/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.spring.config.AbstractReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignNamedContext;

public class ReactiveFeignRibbonConfigurator
extends AbstractReactiveFeignConfigurator {
    protected ReactiveFeignRibbonConfigurator() {
        super(2);
    }

    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        if (!(builder instanceof CloudReactiveFeign.Builder)) {
            throw new IllegalArgumentException("CloudReactiveFeign.Builder expected");
        }
        CloudReactiveFeign.Builder cloudBuilder = (CloudReactiveFeign.Builder)builder;
        String clientName = namedContext.getClientName();
        LoadBalancerCommandFactory balancerCommandFactory = namedContext.getOptional(LoadBalancerCommandFactory.class);
        if (balancerCommandFactory == null) {
            SpringClientFactory springClientFactory = namedContext.getOptional(SpringClientFactory.class);
            balancerCommandFactory = serviceName -> {
                IClientConfig clientConfig = springClientFactory.getClientConfig(clientName);
                ILoadBalancer namedLoadBalancer = springClientFactory.getLoadBalancer(clientName);
                RetryHandler retryHandler = this.getOrInstantiateRetryHandler(namedContext, clientConfig);
                return LoadBalancerCommand.builder().withLoadBalancer(namedLoadBalancer).withRetryHandler(retryHandler).withClientConfig(clientConfig).build();
            };
        }
        cloudBuilder = cloudBuilder.setLoadBalancerCommandFactory(balancerCommandFactory);
        return cloudBuilder;
    }

    private RetryHandler getOrInstantiateRetryHandler(ReactiveFeignNamedContext namedContext, IClientConfig clientConfig) {
        RetryHandler retryHandler = namedContext.getOptional(RetryHandler.class);
        if (retryHandler == null) {
            retryHandler = new DefaultLoadBalancerRetryHandler(clientConfig);
        }
        return retryHandler;
    }
}

