/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.DataBinder;
import reactivefeign.spring.config.ReactiveFeignClientsProperties;
import reactivefeign.spring.config.ReactiveFeignNamedContextFactory;

public class ReactiveFeignNamedContext {
    private final ApplicationContext applicationContext;
    private final ReactiveFeignNamedContextFactory namedContextFactory;
    private final String clientName;

    public ReactiveFeignNamedContext(ApplicationContext applicationContext, String clientName) {
        this.applicationContext = applicationContext;
        this.clientName = clientName;
        this.namedContextFactory = (ReactiveFeignNamedContextFactory)((Object)applicationContext.getBean(ReactiveFeignNamedContextFactory.class));
    }

    public <T> T get(Class<T> type) {
        Object instance = this.namedContextFactory.getInstance(this.clientName, type);
        if (instance == null) {
            throw new IllegalStateException("No bean found of type " + type + " for " + this.clientName);
        }
        return (T)instance;
    }

    public <T> Map<String, T> getAll(Class<T> type) {
        Map instances = this.namedContextFactory.getInstances(this.clientName, type);
        return instances != null ? instances : Collections.emptyMap();
    }

    public <T> T getOptional(Class<T> type) {
        return (T)this.namedContextFactory.getInstance(this.clientName, type);
    }

    public <T> T getOptional(Class<T> type, String beanName) {
        Map instances = this.namedContextFactory.getInstances(this.clientName, type);
        if (instances == null) {
            return null;
        }
        return (T)instances.get(beanName);
    }

    public String getClientName() {
        return this.clientName;
    }

    public List<ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?>> getConfigs() {
        ReactiveFeignClientsProperties properties = this.getProperties();
        Map config = properties.getConfig();
        return Arrays.asList(config.get(this.clientName), config.get(properties.getDefaultConfig()));
    }

    public List<ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?>> getConfigsReverted() {
        ReactiveFeignClientsProperties properties = this.getProperties();
        Map config = properties.getConfig();
        return Arrays.asList(config.get(properties.getDefaultConfig()), config.get(this.clientName));
    }

    public ReactiveFeignClientsProperties getProperties() {
        return (ReactiveFeignClientsProperties)this.applicationContext.getBean(ReactiveFeignClientsProperties.class);
    }

    public <T> T getOrInstantiate(Class<T> tClass) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)BeanUtils.instantiateClass(tClass);
        }
    }

    public <T> T getOrInstantiate(Class<T> tClass, Map args) {
        try {
            return (T)this.applicationContext.getBean(tClass);
        }
        catch (NoSuchBeanDefinitionException e) {
            Object bean = BeanUtils.instantiateClass(tClass);
            if (args != null && !args.isEmpty()) {
                DataBinder dataBinder = new DataBinder(bean);
                dataBinder.bind((PropertyValues)new MutablePropertyValues(args));
                return (T)dataBinder.getTarget();
            }
            return (T)bean;
        }
    }
}

