/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import feign.codec.ErrorDecoder;
import java.util.Map;
import java.util.Objects;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveOptions;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.spring.config.AbstractReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignClientsProperties;
import reactivefeign.spring.config.ReactiveFeignNamedContext;

public class ReactiveFeignBasicConfigurator
extends AbstractReactiveFeignConfigurator {
    protected ReactiveFeignBasicConfigurator() {
        super(1);
    }

    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        if (namedContext.getProperties().isDefaultToProperties()) {
            builder = this.configureUsingConfiguration(builder, namedContext);
            for (ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?> config : namedContext.getConfigsReverted()) {
                builder = this.configureUsingProperties(builder, namedContext, config);
            }
        } else {
            for (ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?> config : namedContext.getConfigsReverted()) {
                builder = this.configureUsingProperties(builder, namedContext, config);
            }
            builder = this.configureUsingConfiguration(builder, namedContext);
        }
        return builder;
    }

    private ReactiveFeignBuilder configureUsingConfiguration(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        ErrorDecoder errorDecoder;
        ReactiveStatusHandler statusHandler;
        Map<String, ReactiveHttpRequestInterceptor> requestInterceptors;
        ReactiveRetryPolicy retryPolicy;
        ReactiveFeignBuilder resultBuilder = builder;
        ReactiveOptions options = namedContext.getOptional(ReactiveOptions.class);
        if (options != null) {
            resultBuilder = resultBuilder.options(options);
        }
        if ((retryPolicy = namedContext.getOptional(ReactiveRetryPolicy.class)) != null) {
            resultBuilder = resultBuilder.retryWhen(retryPolicy);
        }
        if ((requestInterceptors = namedContext.getAll(ReactiveHttpRequestInterceptor.class)) != null) {
            for (ReactiveHttpRequestInterceptor interceptor : requestInterceptors.values()) {
                resultBuilder = resultBuilder.addRequestInterceptor(interceptor);
            }
        }
        if ((statusHandler = namedContext.getOptional(ReactiveStatusHandler.class)) == null && (errorDecoder = namedContext.getOptional(ErrorDecoder.class)) != null) {
            statusHandler = ReactiveStatusHandlers.errorDecoder((ErrorDecoder)errorDecoder);
        }
        if (statusHandler != null) {
            resultBuilder = resultBuilder.statusHandler(statusHandler);
        }
        namedContext.getAll(ReactiveLoggerListener.class).values().forEach(arg_0 -> ((ReactiveFeignBuilder)resultBuilder).addLoggerListener(arg_0));
        return resultBuilder;
    }

    private ReactiveFeignBuilder configureUsingProperties(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext, ReactiveFeignClientsProperties.ReactiveFeignClientProperties<?> config) {
        ReactiveFeignBuilder resultBuilder = builder;
        if (config == null) {
            return resultBuilder;
        }
        Object optionsBuilder = config.getOptions();
        if (optionsBuilder != null) {
            resultBuilder = resultBuilder.options(optionsBuilder.build());
        }
        if (config.getRetry() != null) {
            ReactiveRetryPolicy retryPolicy = ReactiveFeignBasicConfigurator.configureRetryPolicyFromProperties(namedContext, config.getRetry());
            resultBuilder = resultBuilder.retryWhen(retryPolicy);
        }
        if (config.getRequestInterceptors() != null && !config.getRequestInterceptors().isEmpty()) {
            for (Class clazz : config.getRequestInterceptors()) {
                ReactiveHttpRequestInterceptor interceptor = (ReactiveHttpRequestInterceptor)namedContext.getOrInstantiate(clazz);
                resultBuilder = resultBuilder.addRequestInterceptor(interceptor);
            }
        }
        if (config.getStatusHandler() != null) {
            ReactiveStatusHandler statusHandler = namedContext.getOrInstantiate(config.getStatusHandler());
            resultBuilder = resultBuilder.statusHandler(statusHandler);
        } else if (config.getErrorDecoder() != null) {
            ErrorDecoder errorDecoder = namedContext.getOrInstantiate(config.getErrorDecoder());
            resultBuilder = resultBuilder.statusHandler(ReactiveStatusHandlers.errorDecoder((ErrorDecoder)errorDecoder));
        }
        if (config.getLogger() != null) {
            resultBuilder = resultBuilder.addLoggerListener(namedContext.getOrInstantiate(config.getLogger()));
        }
        if (config.getMetricsLogger() != null) {
            resultBuilder = resultBuilder.addLoggerListener((ReactiveLoggerListener)namedContext.getOrInstantiate(config.getMetricsLogger()));
        }
        if (config.getDecode404() != null && config.getDecode404().booleanValue()) {
            resultBuilder = resultBuilder.decode404();
        }
        if (Objects.nonNull(config.getContract())) {
            resultBuilder = resultBuilder.contract(namedContext.getOrInstantiate(config.getContract()));
        }
        return resultBuilder;
    }

    static ReactiveRetryPolicy configureRetryPolicyFromProperties(ReactiveFeignNamedContext namedContext, ReactiveFeignClientsProperties.RetryProperties retryProperties) {
        ReactiveRetryPolicy retryPolicy = null;
        if (retryProperties.getPolicy() != null) {
            retryPolicy = namedContext.getOrInstantiate(retryProperties.getPolicy());
        }
        if (retryPolicy == null) {
            ReactiveRetryPolicy.Builder retryPolicyBuilder = namedContext.getOrInstantiate(retryProperties.getBuilder(), retryProperties.getArgs());
            retryPolicy = retryPolicyBuilder.build();
        }
        return retryPolicy;
    }
}

