/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud2.publisher;

import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.publisher.PublisherHttpClient;
import reactor.core.publisher.Mono;

public class LoadBalancerPublisherClient
implements PublisherHttpClient {
    private final ReactiveLoadBalancer<ServiceInstance> reactiveLoadBalancer;
    private final PublisherHttpClient publisherClient;

    public LoadBalancerPublisherClient(ReactiveLoadBalancer<ServiceInstance> reactiveLoadBalancer, PublisherHttpClient publisherClient) {
        this.reactiveLoadBalancer = reactiveLoadBalancer;
        this.publisherClient = publisherClient;
    }

    public Publisher<Object> executeRequest(ReactiveHttpRequest request) {
        return Mono.from((Publisher)this.reactiveLoadBalancer.choose()).flatMapMany(serviceInstanceResponse -> {
            URI lbUrl = LoadBalancerUriTools.reconstructURI((ServiceInstance)((ServiceInstance)serviceInstanceResponse.getServer()), (URI)request.uri());
            ReactiveHttpRequest lbRequest = new ReactiveHttpRequest(request, lbUrl);
            return this.publisherClient.executeRequest(lbRequest);
        });
    }
}

