/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud.publisher;

import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.LazyInitialized;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class RibbonPublisherClient
implements PublisherHttpClient {
    private final LazyInitialized<LoadBalancerCommand<Object>> loadBalancerCommand = new LazyInitialized(() -> (LoadBalancerCommand)loadBalancerCommandFactory.apply(serviceName));
    private final PublisherHttpClient publisherClient;
    private final Type publisherType;

    public RibbonPublisherClient(LoadBalancerCommandFactory loadBalancerCommandFactory, String serviceName, PublisherHttpClient publisherClient, Type publisherType) {
        this.publisherClient = publisherClient;
        this.publisherType = publisherType;
    }

    public Publisher<Object> executeRequest(ReactiveHttpRequest request) {
        LoadBalancerCommand loadBalancerCommand = (LoadBalancerCommand)this.loadBalancerCommand.get();
        if (loadBalancerCommand != null) {
            Observable observable = loadBalancerCommand.submit(server -> {
                ReactiveHttpRequest lbRequest = this.loadBalanceRequest(request, server);
                Publisher publisher = this.publisherClient.executeRequest(lbRequest);
                return RxReactiveStreams.toObservable((Publisher)publisher);
            });
            Publisher publisher = RxReactiveStreams.toPublisher((Observable)observable);
            if (this.publisherType == Mono.class) {
                return Mono.from((Publisher)publisher);
            }
            if (this.publisherType == Flux.class) {
                return Flux.from((Publisher)publisher);
            }
            throw new IllegalArgumentException("Unknown publisherType: " + this.publisherType);
        }
        return this.publisherClient.executeRequest(request);
    }

    protected ReactiveHttpRequest loadBalanceRequest(ReactiveHttpRequest request, Server server) {
        URI uri = request.uri();
        try {
            URI lbUrl = new URI(uri.getScheme(), uri.getUserInfo(), server.getHost(), server.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return new ReactiveHttpRequest(request.method(), lbUrl, request.headers(), request.body());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

