/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.jetty.client;

import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import feign.MethodMetadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReadTimeoutException;
import reactivefeign.jetty.client.JettyReactiveHttpResponse;
import reactivefeign.utils.FeignUtils;
import reactivefeign.utils.HttpUtils;
import reactivefeign.utils.SerializedFormData;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JettyReactiveHttpClient
implements ReactiveHttpClient {
    private final HttpClient httpClient;
    private final Class bodyActualClass;
    private final Class returnPublisherClass;
    private final Class returnActualClass;
    private final JsonFactory jsonFactory;
    private final ObjectWriter bodyWriter;
    private final ObjectReader responseReader;
    private long requestTimeout = -1L;
    private boolean tryUseCompression;

    public static JettyReactiveHttpClient jettyClient(MethodMetadata methodMetadata, HttpClient httpClient, JsonFactory jsonFactory, ObjectMapper objectMapper) {
        Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
        Type returnActualType = FeignUtils.returnActualType(methodMetadata);
        Type bodyActualType = FeignUtils.getBodyActualType(methodMetadata.bodyType());
        ObjectWriter bodyWriter = bodyActualType != null ? objectMapper.writerFor(objectMapper.constructType(bodyActualType)) : null;
        ObjectReader responseReader = objectMapper.readerFor(objectMapper.constructType(returnActualType));
        return new JettyReactiveHttpClient(httpClient, JettyReactiveHttpClient.getClass(bodyActualType), returnPublisherType, JettyReactiveHttpClient.getClass(returnActualType), jsonFactory, bodyWriter, responseReader);
    }

    public JettyReactiveHttpClient(HttpClient httpClient, Class bodyActualClass, Class returnPublisherClass, Class returnActualClass, JsonFactory jsonFactory, ObjectWriter bodyWriter, ObjectReader responseReader) {
        this.httpClient = httpClient;
        this.bodyActualClass = bodyActualClass;
        this.returnPublisherClass = returnPublisherClass;
        this.returnActualClass = returnActualClass;
        this.jsonFactory = jsonFactory;
        this.bodyWriter = bodyWriter;
        this.responseReader = responseReader;
    }

    public JettyReactiveHttpClient setRequestTimeout(long timeoutInMillis) {
        this.requestTimeout = timeoutInMillis;
        return this;
    }

    public JettyReactiveHttpClient setTryUseCompression(boolean tryUseCompression) {
        this.tryUseCompression = tryUseCompression;
        return this;
    }

    public Mono<ReactiveHttpResponse> executeRequest(ReactiveHttpRequest request) {
        Request jettyRequest = this.httpClient.newRequest(request.uri()).headers(httpFields -> this.setUpHeaders(request, (HttpFields.Mutable)httpFields)).method(request.method());
        if (this.requestTimeout > 0L) {
            jettyRequest.timeout(this.requestTimeout, TimeUnit.MILLISECONDS);
        }
        ReactiveRequest.Builder requestBuilder = ReactiveRequest.newBuilder(jettyRequest);
        if (this.bodyActualClass != null || request.body() instanceof SerializedFormData) {
            requestBuilder.content(this.provideBody(request));
        }
        return Mono.from(requestBuilder.build().response((response, content) -> Mono.just(new JettyReactiveHttpResponse(request, response.getResponse(), (Publisher<Content.Chunk>)content, this.returnPublisherClass, this.returnActualClass, this.jsonFactory, this.responseReader)))).onErrorMap(ex -> {
            if (ex instanceof TimeoutException) {
                return new ReadTimeoutException((Throwable)ex, request);
            }
            return new ReactiveFeignException((Throwable)ex, request);
        });
    }

    protected void setUpHeaders(ReactiveHttpRequest request, HttpFields.Mutable httpHeaders) {
        request.headers().forEach(httpHeaders::put);
        String acceptHeader = CharSequence.class.isAssignableFrom(this.returnActualClass) && this.returnPublisherClass == Mono.class ? "text/plain" : (this.returnActualClass == ByteBuffer.class || this.returnActualClass == byte[].class ? "application/octet-stream" : (this.returnPublisherClass == Mono.class ? "application/json" : "application/stream+json"));
        httpHeaders.put(HttpHeader.ACCEPT.asString(), Collections.singletonList(acceptHeader));
        if (this.tryUseCompression) {
            httpHeaders.put(HttpHeader.ACCEPT_ENCODING.asString(), Collections.singletonList("gzip"));
        } else {
            httpHeaders.remove(HttpHeader.ACCEPT_ENCODING.asString());
        }
    }

    protected ReactiveRequest.Content provideBody(ReactiveHttpRequest request) {
        String contentType;
        CorePublisher<Object> bodyPublisher;
        if (request.body() instanceof SerializedFormData) {
            bodyPublisher = Mono.just(this.toByteBufferChunk(((SerializedFormData)request.body()).getFormData(), false));
            contentType = "application/x-www-form-urlencoded";
        } else if (request.body() instanceof Mono) {
            if (this.bodyActualClass == ByteBuffer.class) {
                bodyPublisher = ((Mono)request.body()).map(data -> this.toByteBufferChunk(data, false));
                contentType = "application/octet-stream";
            } else if (CharSequence.class.isAssignableFrom(this.bodyActualClass)) {
                bodyPublisher = Flux.from(request.body()).map(data -> this.toCharSequenceChunk(data, false));
                contentType = "text/plain;charset=utf-8";
            } else {
                bodyPublisher = Flux.from(request.body()).map(data -> this.toJsonChunk(data, false));
                contentType = "application/json;charset=utf-8";
            }
        } else if (this.bodyActualClass == ByteBuffer.class) {
            bodyPublisher = Flux.concat(Flux.from(request.body()).map(data -> this.toByteBufferChunk(data, true)), Flux.just(Content.Chunk.EOF));
            contentType = "application/octet-stream";
        } else {
            bodyPublisher = Flux.concat(Flux.from(request.body()).map(data -> this.toJsonChunk(data, true)), Flux.just(Content.Chunk.EOF));
            contentType = "application/stream+json;charset=utf-8";
        }
        return ReactiveRequest.Content.fromPublisher(bodyPublisher, contentType);
    }

    protected Content.Chunk toByteBufferChunk(Object data, boolean stream) {
        return Content.Chunk.from((ByteBuffer)data, !stream);
    }

    protected Content.Chunk toCharSequenceChunk(Object data, boolean stream) {
        CharBuffer charBuffer = CharBuffer.wrap((CharSequence)data);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        return Content.Chunk.from(byteBuffer, !stream);
    }

    protected Content.Chunk toJsonChunk(Object data, boolean stream) {
        try {
            ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
            this.bodyWriter.writeValue(byteArrayBuilder, data);
            if (stream) {
                byteArrayBuilder.write(HttpUtils.NEWLINE_SEPARATOR);
            }
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayBuilder.toByteArray());
            return Content.Chunk.from(buffer, !stream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Class getClass(Type type) {
        Type type2;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            type2 = pt.getRawType();
        } else {
            type2 = type;
        }
        return (Class)type2;
    }
}

