/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.reactivex.netty.pipeline.PipelineConfigurator;

public class HttpObjectAggregationConfigurator<R extends FullHttpMessage, W>
implements PipelineConfigurator<R, W> {
    public static final String AGGREGATOR_HANDLER_NAME = "http-aggregator";
    public static final int DEFAULT_CHUNK_SIZE = 0x100000;
    private final int maxChunkSize;

    public HttpObjectAggregationConfigurator() {
        this(0x100000);
    }

    public HttpObjectAggregationConfigurator(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(AGGREGATOR_HANDLER_NAME, (ChannelHandler)new HttpObjectAggregator(this.maxChunkSize));
    }
}

