/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class StatusHandlerPostProcessor<P extends Publisher<?>>
implements ReactiveHttpResponseMapper<P> {
    private final ReactiveStatusHandler statusHandler;
    private static final ReactiveStatusHandler defaultStatusHandler = ReactiveStatusHandlers.defaultFeignErrorDecoder();

    public static StatusHandlerPostProcessor handleStatus(ReactiveStatusHandler statusHandler) {
        return new StatusHandlerPostProcessor(statusHandler);
    }

    private StatusHandlerPostProcessor(ReactiveStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public Mono<ReactiveHttpResponse<P>> apply(ReactiveHttpResponse<P> response) {
        String methodKey = response.request().methodKey();
        if (this.statusHandler.shouldHandle(response.status())) {
            return this.statusHandler.decode(methodKey, response).map(throwable -> {
                throw Exceptions.propagate(throwable);
            });
        }
        if (defaultStatusHandler.shouldHandle(response.status())) {
            return defaultStatusHandler.decode(methodKey, response).map(throwable -> {
                throw Exceptions.propagate(throwable);
            });
        }
        return Mono.just(response);
    }
}

