/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.Contract;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Clock;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveContract;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveInvocationHandler;
import reactivefeign.client.ReactiveErrorMapper;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpClientFactory;
import reactivefeign.client.ReactiveHttpExchangeFilterFunction;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.ResponseMappers;
import reactivefeign.client.StatusHandlerPostProcessor;
import reactivefeign.client.log.DefaultReactiveLogger;
import reactivefeign.client.log.LoggerExchangeFilterFunction;
import reactivefeign.client.log.ReactiveLoggerListener;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactivefeign.methodhandler.DefaultMethodHandler;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.methodhandler.ReactiveMethodHandlerFactory;
import reactivefeign.methodhandler.fallback.FallbackMethodHandlerFactory;
import reactivefeign.publisher.FluxPublisherHttpClient;
import reactivefeign.publisher.MonoPublisherHttpClient;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.publisher.ResponsePublisherHttpClient;
import reactivefeign.publisher.retry.FluxRetryPublisherHttpClient;
import reactivefeign.publisher.retry.MonoRetryPublisherHttpClient;
import reactivefeign.retry.ReactiveRetryPolicy;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFeign {
    private final Contract contract;
    private final MethodHandlerFactory methodHandlerFactory;
    private final InvocationHandlerFactory invocationHandlerFactory;

    protected ReactiveFeign(Contract contract, MethodHandlerFactory methodHandlerFactory, InvocationHandlerFactory invocationHandlerFactory) {
        this.contract = contract;
        this.methodHandlerFactory = methodHandlerFactory;
        this.invocationHandlerFactory = invocationHandlerFactory;
    }

    public <T> T newInstance(Target<T> target) {
        Map<String, MethodHandler> nameToHandler = this.targetToHandlersByName(target);
        LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
        LinkedList<DefaultMethodHandler> defaultMethodHandlers = new LinkedList<DefaultMethodHandler>();
        for (Method method : target.type().getMethods()) {
            if (Util.isDefault(method)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method, handler);
                continue;
            }
            methodToHandler.put(method, nameToHandler.get(Feign.configKey(target.type(), method)));
        }
        InvocationHandler handler = this.invocationHandlerFactory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    Map<String, MethodHandler> targetToHandlersByName(Target target) {
        Map<String, MethodMetadata> metadata = this.contract.parseAndValidateMetadata(target.type()).stream().collect(Collectors.toMap(MethodMetadata::configKey, md -> md));
        Map<String, Method> configKeyToMethod = Stream.of(target.type().getMethods()).collect(Collectors.toMap(method -> Feign.configKey(target.type(), method), method -> method));
        LinkedHashMap<String, MethodHandler> result = new LinkedHashMap<String, MethodHandler>();
        this.methodHandlerFactory.target(target);
        for (Map.Entry<String, Method> entry : configKeyToMethod.entrySet()) {
            String configKey = entry.getKey();
            MethodMetadata md2 = metadata.get(configKey);
            MethodHandler methodHandler = md2 != null ? this.methodHandlerFactory.create(md2) : this.methodHandlerFactory.createDefault(entry.getValue());
            result.put(configKey, methodHandler);
        }
        return result;
    }

    public static abstract class Builder<T>
    implements ReactiveFeignBuilder<T> {
        protected Contract contract;
        protected List<ReactiveHttpExchangeFilterFunction> exchangeFilterFunctions = new ArrayList<ReactiveHttpExchangeFilterFunction>();
        protected ReactiveStatusHandler statusHandler = ReactiveStatusHandlers.defaultFeignErrorDecoder();
        protected ReactiveErrorMapper errorMapper;
        protected List<ReactiveLoggerListener<Object>> loggerListeners = new ArrayList<ReactiveLoggerListener<Object>>();
        protected InvocationHandlerFactory invocationHandlerFactory = new ReactiveInvocationHandler.Factory();
        protected boolean decode404 = false;
        private ReactiveRetryPolicy retryPolicy;
        protected FallbackFactory fallbackFactory;

        protected Builder() {
            this.contract(new Contract.Default());
            this.addLoggerListener(new DefaultReactiveLogger(Clock.systemUTC()));
        }

        protected abstract ReactiveHttpClientFactory clientFactory();

        @Override
        public Builder<T> contract(Contract contract) {
            this.contract = new ReactiveContract(contract);
            return this;
        }

        @Override
        public Builder<T> addRequestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            this.exchangeFilterFunctions.add(ReactiveHttpExchangeFilterFunction.ofRequestProcessor(requestInterceptor));
            return this;
        }

        @Override
        public Builder<T> addLoggerListener(ReactiveLoggerListener loggerListener) {
            this.loggerListeners.add(loggerListener);
            return this;
        }

        @Override
        public Builder<T> decode404() {
            this.decode404 = true;
            return this;
        }

        @Override
        public ReactiveFeignBuilder<T> addExchangeFilterFunction(ReactiveHttpExchangeFilterFunction exchangeFilterFunction) {
            this.exchangeFilterFunctions.add(exchangeFilterFunction);
            return this;
        }

        @Override
        public Builder<T> errorMapper(ReactiveErrorMapper errorMapper) {
            this.errorMapper = errorMapper;
            return this;
        }

        @Override
        public Builder<T> statusHandler(ReactiveStatusHandler statusHandler) {
            this.statusHandler = statusHandler;
            return this;
        }

        @Override
        public Builder<T> responseMapper(ReactiveHttpResponseMapper responseMapper) {
            this.exchangeFilterFunctions.add(ReactiveHttpExchangeFilterFunction.ofResponseProcessor(responseMapper));
            return this;
        }

        @Override
        public Builder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        @Override
        public Builder<T> fallback(T fallback) {
            return this.fallbackFactory(throwable -> fallback);
        }

        @Override
        public Builder<T> fallbackFactory(FallbackFactory<T> fallbackFactory) {
            this.fallbackFactory = fallbackFactory;
            return this;
        }

        @Override
        public Contract contract() {
            return this.contract;
        }

        @Override
        public InvocationHandlerFactory invocationHandlerFactory() {
            return this.invocationHandlerFactory;
        }

        @Override
        public PublisherClientFactory buildReactiveClientFactory() {
            final ReactiveHttpClientFactory clientFactory = this.clientFactory();
            return new PublisherClientFactory(){
                Target target;

                @Override
                public void target(Target target) {
                    clientFactory.target(target);
                    this.target = target;
                }

                @Override
                public PublisherHttpClient create(MethodMetadata methodMetadata) {
                    Util.checkNotNull(clientFactory, "clientFactory wasn't provided in ReactiveFeign builder", new Object[0]);
                    ReactiveHttpClient reactiveClient = clientFactory.create(methodMetadata);
                    ArrayList<ReactiveHttpExchangeFilterFunction> exchangeFilterFunctionsAll = new ArrayList<ReactiveHttpExchangeFilterFunction>(exchangeFilterFunctions);
                    if (errorMapper != null) {
                        exchangeFilterFunctionsAll.add(ReactiveHttpExchangeFilterFunction.ofErrorMapper(errorMapper));
                    }
                    if (statusHandler != null) {
                        exchangeFilterFunctionsAll.add(ReactiveHttpExchangeFilterFunction.ofResponseProcessor(StatusHandlerPostProcessor.handleStatus(statusHandler)));
                    }
                    if (decode404) {
                        exchangeFilterFunctionsAll.add(ReactiveHttpExchangeFilterFunction.ofResponseProcessor(ResponseMappers.ignore404()));
                    }
                    for (ReactiveLoggerListener<Object> loggerListener : loggerListeners) {
                        exchangeFilterFunctionsAll.add(LoggerExchangeFilterFunction.log(methodMetadata, this.target, loggerListener));
                    }
                    Optional exchangeFilterFunction = exchangeFilterFunctionsAll.stream().reduce(ReactiveHttpExchangeFilterFunction::then);
                    if (exchangeFilterFunction.isPresent()) {
                        reactiveClient = ((ReactiveHttpExchangeFilterFunction)exchangeFilterFunction.get()).filter(reactiveClient);
                    }
                    PublisherHttpClient publisherClient = this.toPublisher(reactiveClient, methodMetadata);
                    if (retryPolicy != null) {
                        publisherClient = Builder.retry(publisherClient, methodMetadata, retryPolicy);
                    }
                    return publisherClient;
                }
            };
        }

        @Override
        public MethodHandlerFactory buildReactiveMethodHandlerFactory(PublisherClientFactory reactiveClientFactory) {
            ReactiveMethodHandlerFactory methodHandlerFactory = new ReactiveMethodHandlerFactory(reactiveClientFactory);
            return this.fallbackFactory != null ? new FallbackMethodHandlerFactory(methodHandlerFactory, this.fallbackFactory) : methodHandlerFactory;
        }

        public static PublisherHttpClient retry(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, ReactiveRetryPolicy retryPolicy) {
            Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
            if (returnPublisherType == Mono.class) {
                return new MonoRetryPublisherHttpClient(publisherClient, methodMetadata, retryPolicy);
            }
            if (returnPublisherType == Flux.class) {
                return new FluxRetryPublisherHttpClient(publisherClient, methodMetadata, retryPolicy);
            }
            throw new IllegalArgumentException("Unknown returnPublisherType: " + returnPublisherType);
        }

        protected PublisherHttpClient toPublisher(ReactiveHttpClient reactiveHttpClient, MethodMetadata methodMetadata) {
            if (FeignUtils.isResponsePublisher(methodMetadata.returnType())) {
                return new ResponsePublisherHttpClient(reactiveHttpClient);
            }
            Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
            if (returnPublisherType == Mono.class) {
                return new MonoPublisherHttpClient(reactiveHttpClient);
            }
            if (returnPublisherType == Flux.class) {
                return new FluxPublisherHttpClient(reactiveHttpClient);
            }
            throw new IllegalArgumentException("Unknown returnPublisherType: " + returnPublisherType);
        }
    }
}

