/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.Objects;
import org.eclipse.jetty.util.thread.AutoLock;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSinglePublisher<T>
implements Publisher<T>,
Subscription {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSinglePublisher.class);
    private final AutoLock lock = new AutoLock();
    private Subscriber<? super T> subscriber;

    protected AutoLock lock() {
        return this.lock.lock();
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "invalid 'null' subscriber");
        IllegalStateException failure = null;
        try (AutoLock ignored = this.lock();){
            if (this.subscriber != null) {
                failure = new IllegalStateException("multiple subscribers not supported");
            } else {
                this.subscriber = subscriber;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} subscription from {}", (Object)this, (Object)subscriber);
        }
        subscriber.onSubscribe(this);
        if (failure != null) {
            this.onFailure(subscriber, failure);
        }
    }

    protected Subscriber<? super T> subscriber() {
        try (AutoLock ignored = this.lock();){
            Subscriber<? super T> subscriber = this.subscriber;
            return subscriber;
        }
    }

    @Override
    public void request(long n) {
        Subscriber<? super T> subscriber;
        IllegalArgumentException failure = null;
        try (AutoLock ignored = this.lock();){
            subscriber = this.subscriber;
            if (n <= 0L) {
                failure = new IllegalArgumentException("reactive stream violation rule 3.9");
            }
        }
        if (failure != null) {
            this.onFailure(subscriber, failure);
        } else {
            this.onRequest(subscriber, n);
        }
    }

    protected abstract void onRequest(Subscriber<? super T> var1, long var2);

    protected void onFailure(Subscriber<? super T> subscriber, Throwable failure) {
        this.emitOnError(subscriber, failure);
    }

    protected void emitOnNext(Subscriber<? super T> subscriber, T item) {
        subscriber.onNext(item);
    }

    protected void emitOnError(Subscriber<? super T> subscriber, Throwable failure) {
        this.reset();
        subscriber.onError(failure);
    }

    protected void emitOnComplete(Subscriber<? super T> subscriber) {
        this.reset();
        subscriber.onComplete();
    }

    @Override
    public void cancel() {
        Subscriber<T> subscriber;
        try (AutoLock ignored = this.lock();){
            subscriber = this.subscriber();
            this.reset();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} cancelled subscription from {}", (Object)this, (Object)subscriber);
        }
    }

    private void reset() {
        try (AutoLock ignored = this.lock();){
            this.subscriber = null;
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

