/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCopier
extends IteratingNestedCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ContentCopier.class);
    private final Content.Source source;
    private final Content.Sink sink;
    private final Content.Chunk.Processor chunkProcessor;
    private Content.Chunk current;
    private boolean terminated;

    public ContentCopier(Content.Source source, Content.Sink sink, Content.Chunk.Processor chunkProcessor, Callback callback) {
        super(callback);
        this.source = source;
        this.sink = sink;
        this.chunkProcessor = chunkProcessor;
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    @Override
    protected IteratingCallback.Action process() throws Throwable {
        if (this.terminated) {
            return IteratingCallback.Action.SUCCEEDED;
        }
        this.current = this.source.read();
        if (this.current == null) {
            this.source.demand(this::iterate);
            return IteratingCallback.Action.IDLE;
        }
        if (this.chunkProcessor != null && this.chunkProcessor.process(this.current, this)) {
            return IteratingCallback.Action.SCHEDULED;
        }
        if (Content.Chunk.isFailure(this.current)) {
            throw this.current.getFailure();
        }
        this.sink.write(this.current.isLast(), this.current.getByteBuffer(), this);
        return IteratingCallback.Action.SCHEDULED;
    }

    @Override
    public void succeeded() {
        this.terminated = this.current.isLast();
        this.current.release();
        this.current = null;
        super.succeeded();
    }

    @Override
    public void failed(Throwable x) {
        if (this.current != null) {
            this.current.release();
        }
        this.current = null;
        this.source.fail(x);
        super.failed(x);
    }
}

