/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Request;
import feign.Response;
import feign.Util;
import java.util.Collection;
import java.util.Map;

public final class TypedResponse<T> {
    private final int status;
    private final String reason;
    private final Map<String, Collection<String>> headers;
    private final T body;
    private final Request request;
    private final Request.ProtocolVersion protocolVersion;

    private TypedResponse(Builder<T> builder) {
        Util.checkState(builder.request != null, "original request is required", new Object[0]);
        this.status = builder.status;
        this.request = builder.request;
        this.reason = builder.reason;
        this.headers = Util.caseInsensitiveCopyOf(builder.headers);
        this.body = builder.body;
        this.protocolVersion = ((Builder)builder).protocolVersion;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Response source) {
        return new Builder(source);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public Map<String, Collection<String>> headers() {
        return this.headers;
    }

    public T body() {
        return this.body;
    }

    public Request request() {
        return this.request;
    }

    public Request.ProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.protocolVersion.toString()).append(" ").append(this.status);
        if (this.reason != null) {
            builder.append(' ').append(this.reason);
        }
        builder.append('\n');
        for (String field : this.headers.keySet()) {
            for (String value : Util.valuesOrEmpty(this.headers, field)) {
                builder.append(field).append(": ").append(value).append('\n');
            }
        }
        if (this.body != null) {
            builder.append('\n').append(this.body);
        }
        return builder.toString();
    }

    public static final class Builder<T> {
        int status;
        String reason;
        Map<String, Collection<String>> headers;
        T body;
        Request request;
        private Request.ProtocolVersion protocolVersion = Request.ProtocolVersion.HTTP_1_1;

        Builder() {
        }

        Builder(Response source) {
            this.status = source.status();
            this.reason = source.reason();
            this.headers = source.headers();
            this.request = source.request();
            this.protocolVersion = source.protocolVersion();
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder headers(Map<String, Collection<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder body(T body2) {
            this.body = body2;
            return this;
        }

        public Builder request(Request request) {
            Util.checkNotNull(request, "request is required", new Object[0]);
            this.request = request;
            return this;
        }

        public Builder protocolVersion(Request.ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public TypedResponse build() {
            return new TypedResponse(this);
        }
    }
}

