/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.MethodMetadata;
import feign.Param;
import feign.QueryMapEncoder;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.template.UriUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class RequestTemplateFactoryResolver {
    private final Encoder encoder;
    private final QueryMapEncoder queryMapEncoder;

    RequestTemplateFactoryResolver(Encoder encoder, QueryMapEncoder queryMapEncoder) {
        this.encoder = Util.checkNotNull(encoder, "encoder", new Object[0]);
        this.queryMapEncoder = Util.checkNotNull(queryMapEncoder, "queryMapEncoder", new Object[0]);
    }

    public RequestTemplate.Factory resolve(Target<?> target, MethodMetadata md) {
        if (!md.formParams().isEmpty() && md.template().bodyTemplate() == null) {
            return new BuildFormEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target);
        }
        if (md.bodyIndex() != null || md.alwaysEncodeBody()) {
            return new BuildEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target);
        }
        return new BuildTemplateByResolvingArgs(md, this.queryMapEncoder, target);
    }

    private static class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            boolean alwaysEncodeBody = mutable.methodMetadata().alwaysEncodeBody();
            Object[] body2 = null;
            if (!alwaysEncodeBody) {
                body2 = argv[this.metadata.bodyIndex()];
                Util.checkArgument(body2 != null, "Body parameter %s was null", this.metadata.bodyIndex());
            }
            try {
                if (alwaysEncodeBody) {
                    body2 = argv == null ? new Object[]{} : argv;
                    this.encoder.encode(body2, (Type)((Object)Object[].class), mutable);
                } else {
                    this.encoder.encode(body2, this.metadata.bodyType(), mutable);
                }
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildFormEncodedTemplateFromArgs(MethodMetadata metadata, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            LinkedHashMap<String, Object> formVariables = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildTemplateByResolvingArgs
    implements RequestTemplate.Factory {
        private final QueryMapEncoder queryMapEncoder;
        protected final MethodMetadata metadata;
        protected final Target<?> target;
        private final Map<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();

        private BuildTemplateByResolvingArgs(MethodMetadata metadata, QueryMapEncoder queryMapEncoder, Target target) {
            this.metadata = metadata;
            this.target = target;
            this.queryMapEncoder = queryMapEncoder;
            if (metadata.indexToExpander() != null) {
                this.indexToExpander.putAll(metadata.indexToExpander());
                return;
            }
            if (metadata.indexToExpanderClass().isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Class<? extends Param.Expander>> indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
                try {
                    this.indexToExpander.put(indexToExpanderClass.getKey(), indexToExpanderClass.getValue().newInstance());
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public RequestTemplate create(Object[] argv) {
            Object value;
            RequestTemplate mutable = RequestTemplate.from(this.metadata.template());
            mutable.feignTarget(this.target);
            if (this.metadata.urlIndex() != null) {
                int urlIndex = this.metadata.urlIndex();
                Util.checkArgument(argv[urlIndex] != null, "URI parameter %s was null", urlIndex);
                mutable.target(String.valueOf(argv[urlIndex]));
            }
            LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
            for (Map.Entry<Integer, Collection<String>> entry : this.metadata.indexToName().entrySet()) {
                int i2 = entry.getKey();
                Object value2 = argv[entry.getKey()];
                if (value2 == null) continue;
                if (this.indexToExpander.containsKey(i2)) {
                    value2 = this.expandElements(this.indexToExpander.get(i2), value2);
                }
                for (String name : entry.getValue()) {
                    varBuilder.put(name, value2);
                }
            }
            RequestTemplate template = this.resolve(argv, mutable, varBuilder);
            if (this.metadata.queryMapIndex() != null) {
                value = argv[this.metadata.queryMapIndex()];
                Map<String, Object> queryMap = this.toQueryMap(value, this.metadata.queryMapEncoder());
                template = this.addQueryMapQueryParameters(queryMap, template);
            }
            if (this.metadata.headerMapIndex() != null) {
                value = argv[this.metadata.headerMapIndex()];
                Map<String, Object> headerMap = this.toQueryMap(value, this.metadata.queryMapEncoder());
                template = this.addHeaderMapHeaders(headerMap, template);
            }
            return template;
        }

        private Map<String, Object> toQueryMap(Object value, QueryMapEncoder queryMapEncoder) {
            if (value instanceof Map) {
                return (Map)value;
            }
            try {
                return queryMapEncoder != null ? queryMapEncoder.encode(value) : this.queryMapEncoder.encode(value);
            }
            catch (EncodeException e) {
                throw new IllegalStateException(e);
            }
        }

        private Object expandElements(Param.Expander expander, Object value) {
            if (value instanceof Iterable) {
                return this.expandIterable(expander, (Iterable)value);
            }
            return expander.expand(value);
        }

        private List<String> expandIterable(Param.Expander expander, Iterable value) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object element : value) {
                if (element == null) continue;
                values.add(expander.expand(element));
            }
            return values;
        }

        private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values.add(nextObject == null ? null : nextObject.toString());
                    }
                } else {
                    values.add(currValue == null ? null : currValue.toString());
                }
                mutable.header(currEntry.getKey(), values);
            }
            return mutable;
        }

        private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values.add(nextObject == null ? null : UriUtils.encode(nextObject.toString()));
                    }
                } else if (currValue instanceof Object[]) {
                    for (Object value : (Object[])currValue) {
                        values.add(value == null ? null : UriUtils.encode(value.toString()));
                    }
                } else if (currValue != null) {
                    values.add(UriUtils.encode(currValue.toString()));
                }
                if (values.size() <= 0) continue;
                mutable.query(UriUtils.encode(currEntry.getKey()), values);
            }
            return mutable;
        }

        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            return mutable.resolve(variables);
        }
    }
}

