/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class SerializedFormData
implements Publisher<Object> {
    private final String formDataString;
    private final ByteBuffer formData;
    private final Consumer<Object> logger;

    public SerializedFormData(String formDataString, ByteBuffer formData) {
        this(formDataString, formData, null);
    }

    private SerializedFormData(String formDataString, ByteBuffer formData, Consumer<Object> logger) {
        this.formDataString = formDataString;
        this.formData = formData;
        this.logger = logger;
    }

    public ByteBuffer getFormData() {
        if (this.logger != null) {
            this.logger.accept(this);
        }
        return this.formData;
    }

    public String getFormDataString() {
        if (this.logger != null) {
            this.logger.accept(this);
        }
        return this.formDataString;
    }

    @Override
    public void subscribe(Subscriber<? super Object> s) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.formDataString;
    }

    public SerializedFormData logged(Consumer<Object> logger) {
        return new SerializedFormData(this.formDataString, this.formData, logger);
    }
}

