/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.util.DigestUtils;
import org.springframework.web.reactive.resource.AbstractFileNameVersionStrategy;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ContentVersionStrategy
extends AbstractFileNameVersionStrategy {
    @Override
    public Mono<String> getResourceVersion(Resource resource) {
        Flux<DataBuffer> flux = DataBufferUtils.read(resource, DefaultDataBufferFactory.sharedInstance, 8192);
        return DataBufferUtils.join(flux).map(buffer -> {
            byte[] result = new byte[buffer.readableByteCount()];
            buffer.read(result);
            DataBufferUtils.release(buffer);
            return DigestUtils.md5DigestAsHex(result);
        });
    }
}

