/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.StringWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.EncodedResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceTransformerSupport;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CssLinkResourceTransformer
extends ResourceTransformerSupport {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(CssLinkResourceTransformer.class);
    private final List<LinkParser> linkParsers = new ArrayList<LinkParser>(2);

    public CssLinkResourceTransformer() {
        this.linkParsers.add(new ImportLinkParser());
        this.linkParsers.add(new UrlFunctionLinkParser());
    }

    @Override
    public Mono<Resource> transform(ServerWebExchange exchange2, Resource inputResource, ResourceTransformerChain transformerChain) {
        return transformerChain.transform(exchange2, inputResource).flatMap(outputResource -> {
            String filename = outputResource.getFilename();
            if (!"css".equals(StringUtils.getFilenameExtension(filename)) || inputResource instanceof EncodedResourceResolver.EncodedResource) {
                return Mono.just(outputResource);
            }
            DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
            Flux<DataBuffer> flux = DataBufferUtils.read(outputResource, bufferFactory, 8192);
            return DataBufferUtils.join(flux).flatMap(dataBuffer -> {
                CharBuffer charBuffer = DEFAULT_CHARSET.decode(dataBuffer.asByteBuffer());
                DataBufferUtils.release(dataBuffer);
                String cssContent = charBuffer.toString();
                return this.transformContent(cssContent, (Resource)outputResource, transformerChain, exchange2);
            });
        });
    }

    private Mono<? extends Resource> transformContent(String cssContent, Resource resource, ResourceTransformerChain chain, ServerWebExchange exchange2) {
        List<ContentChunkInfo> contentChunkInfos = this.parseContent(cssContent);
        if (contentChunkInfos.isEmpty()) {
            return Mono.just(resource);
        }
        return Flux.fromIterable(contentChunkInfos).concatMap(contentChunkInfo -> {
            String contentChunk = contentChunkInfo.getContent(cssContent);
            if (contentChunkInfo.isLink() && !this.hasScheme(contentChunk)) {
                String link = this.toAbsolutePath(contentChunk, exchange2);
                return this.resolveUrlPath(link, exchange2, resource, chain).defaultIfEmpty(contentChunk);
            }
            return Mono.just(contentChunk);
        }).reduce(new StringWriter(), (writer, chunk) -> {
            writer.write((String)chunk);
            return writer;
        }).map(writer -> {
            byte[] newContent = writer.toString().getBytes(DEFAULT_CHARSET);
            return new TransformedResource(resource, newContent);
        });
    }

    private List<ContentChunkInfo> parseContent(String cssContent) {
        TreeSet links = new TreeSet();
        this.linkParsers.forEach(parser -> parser.parse(cssContent, links));
        if (links.isEmpty()) {
            return Collections.emptyList();
        }
        int index = 0;
        ArrayList<ContentChunkInfo> result = new ArrayList<ContentChunkInfo>();
        for (ContentChunkInfo link : links) {
            result.add(new ContentChunkInfo(index, link.getStart(), false));
            result.add(link);
            index = link.getEnd();
        }
        if (index < cssContent.length()) {
            result.add(new ContentChunkInfo(index, cssContent.length(), false));
        }
        return result;
    }

    private boolean hasScheme(String link) {
        int schemeIndex = link.indexOf(58);
        return schemeIndex > 0 && !link.substring(0, schemeIndex).contains("/") || link.indexOf("//") == 0;
    }

    private static class ImportLinkParser
    extends AbstractLinkParser {
        private ImportLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "@import";
        }

        @Override
        protected int extractUnquotedLink(int position, String content, Set<ContentChunkInfo> result) {
            if (!content.startsWith("url(", position) && logger.isTraceEnabled()) {
                logger.trace("Unexpected syntax for @import link at index " + position);
            }
            return position;
        }
    }

    private static class UrlFunctionLinkParser
    extends AbstractLinkParser {
        private UrlFunctionLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "url(";
        }

        @Override
        protected int extractUnquotedLink(int position, String content, Set<ContentChunkInfo> result) {
            return this.extractLink(position - 1, ')', content, result);
        }
    }

    private static class ContentChunkInfo
    implements Comparable<ContentChunkInfo> {
        private final int start;
        private final int end;
        private final boolean isLink;

        ContentChunkInfo(int start, int end, boolean isLink) {
            this.start = start;
            this.end = end;
            this.isLink = isLink;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isLink() {
            return this.isLink;
        }

        public String getContent(String fullContent) {
            return fullContent.substring(this.start, this.end);
        }

        @Override
        public int compareTo(ContentChunkInfo other) {
            return Integer.compare(this.start, other.start);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContentChunkInfo)) {
                return false;
            }
            ContentChunkInfo otherCci = (ContentChunkInfo)other;
            return this.start == otherCci.start && this.end == otherCci.end;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }
    }

    @FunctionalInterface
    protected static interface LinkParser {
        public void parse(String var1, SortedSet<ContentChunkInfo> var2);
    }

    protected static abstract class AbstractLinkParser
    implements LinkParser {
        protected AbstractLinkParser() {
        }

        protected abstract String getKeyword();

        @Override
        public void parse(String content, SortedSet<ContentChunkInfo> result) {
            int position = 0;
            while ((position = content.indexOf(this.getKeyword(), position)) != -1) {
                position += this.getKeyword().length();
                while (Character.isWhitespace(content.charAt(position))) {
                    ++position;
                }
                if (content.charAt(position) == '\'') {
                    position = this.extractLink(position, '\'', content, result);
                    continue;
                }
                if (content.charAt(position) == '\"') {
                    position = this.extractLink(position, '\"', content, result);
                    continue;
                }
                position = this.extractUnquotedLink(position, content, result);
            }
            return;
        }

        protected int extractLink(int index, char endChar, String content, Set<ContentChunkInfo> result) {
            int start = index + 1;
            int end = content.indexOf(endChar, start);
            result.add(new ContentChunkInfo(start, end, true));
            return end + 1;
        }

        protected abstract int extractUnquotedLink(int var1, String var2, Set<ContentChunkInfo> var3);
    }
}

