/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.support;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class FilePatternResourceHintsRegistrar {
    private final List<String> names;
    private final List<String> locations;
    private final List<String> extensions;

    public FilePatternResourceHintsRegistrar(List<String> names, List<String> locations, List<String> extensions) {
        this.names = FilePatternResourceHintsRegistrar.validateNames(names);
        this.locations = FilePatternResourceHintsRegistrar.validateLocations(locations);
        this.extensions = FilePatternResourceHintsRegistrar.validateExtensions(extensions);
    }

    private static List<String> validateNames(List<String> names) {
        for (String name : names) {
            if (!name.contains("*")) continue;
            throw new IllegalArgumentException("File name '" + name + "' cannot contain '*'");
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> validateLocations(List<String> locations) {
        Assert.notEmpty(locations, "At least one location should be specified");
        ArrayList<String> parsedLocations = new ArrayList<String>();
        for (String string : locations) {
            void var3_3;
            void var3_8;
            void var3_6;
            if (string.startsWith("classpath:")) {
                String string2 = string.substring("classpath:".length());
            }
            if (var3_6.startsWith("/")) {
                String string3 = var3_6.substring(1);
            }
            if (!var3_8.isEmpty() && !var3_8.endsWith("/")) {
                String string4 = (String)var3_8 + "/";
            }
            parsedLocations.add((String)var3_3);
        }
        return parsedLocations;
    }

    private static List<String> validateExtensions(List<String> extensions) {
        for (String extension : extensions) {
            if (extension.startsWith(".")) continue;
            throw new IllegalArgumentException("Extension '" + extension + "' should start with '.'");
        }
        return extensions;
    }

    public void registerHints(ResourceHints hints, @Nullable ClassLoader classLoader) {
        ClassLoader classLoaderToUse = classLoader != null ? classLoader : this.getClass().getClassLoader();
        ArrayList<CallSite> includes = new ArrayList<CallSite>();
        for (String location : this.locations) {
            if (classLoaderToUse.getResource(location) == null) continue;
            for (String extension : this.extensions) {
                for (String name : this.names) {
                    includes.add((CallSite)((Object)(location + name + "*" + extension)));
                }
            }
        }
        if (!includes.isEmpty()) {
            hints.registerPattern(hint -> hint.includes((String[])includes.toArray(String[]::new)));
        }
    }
}

