/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.time.Instant;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractMessageWriterResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseEntityResultHandler
extends AbstractMessageWriterResultHandler
implements HandlerResultHandler {
    private static final Set<HttpMethod> SAFE_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver) {
        this(writers, resolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    public ResponseEntityResultHandler(List<HttpMessageWriter<?>> writers, RequestedContentTypeResolver resolver, ReactiveAdapterRegistry registry) {
        super(writers, resolver, registry);
        this.setOrder(0);
    }

    @Override
    public boolean supports(HandlerResult result) {
        Class<?> valueType = ResponseEntityResultHandler.resolveReturnValueType(result);
        if (this.isSupportedType(valueType)) {
            return true;
        }
        ReactiveAdapter adapter = this.getAdapter(result);
        return adapter != null && !adapter.isNoValue() && this.isSupportedType(result.getReturnType().getGeneric(new int[0]).toClass());
    }

    @Nullable
    private static Class<?> resolveReturnValueType(HandlerResult result) {
        Class<?> valueType = result.getReturnType().toClass();
        Object value = result.getReturnValue();
        if (valueType == Object.class && value != null) {
            valueType = value.getClass();
        }
        return valueType;
    }

    private boolean isSupportedType(@Nullable Class<?> clazz) {
        return clazz != null && (HttpEntity.class.isAssignableFrom(clazz) && !RequestEntity.class.isAssignableFrom(clazz) || HttpHeaders.class.isAssignableFrom(clazz));
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange2, HandlerResult result) {
        MethodParameter bodyParameter;
        Mono<Object> returnValueMono;
        ReactiveAdapter adapter = this.getAdapter(result);
        MethodParameter actualParameter = result.getReturnTypeSource();
        if (adapter != null) {
            Assert.isTrue(!adapter.isMultiValue(), "Only a single ResponseEntity supported");
            returnValueMono = Mono.from(adapter.toPublisher(result.getReturnValue()));
            boolean isContinuation = KotlinDetector.isSuspendingFunction(actualParameter.getMethod()) && !"kotlinx.coroutines.flow.Flow".equals(actualParameter.getParameterType().getName());
            bodyParameter = isContinuation ? actualParameter.nested() : actualParameter.nested().nested();
        } else {
            returnValueMono = Mono.justOrEmpty(result.getReturnValue());
            bodyParameter = actualParameter.nested();
        }
        return returnValueMono.flatMap(returnValue -> {
            ResponseEntity httpEntity;
            if (returnValue instanceof HttpEntity) {
                httpEntity = (ResponseEntity)returnValue;
            } else if (returnValue instanceof HttpHeaders) {
                httpEntity = new ResponseEntity((HttpHeaders)returnValue, HttpStatus.OK);
            } else {
                throw new IllegalArgumentException("HttpEntity or HttpHeaders expected but got: " + returnValue.getClass());
            }
            if (httpEntity instanceof ResponseEntity) {
                exchange2.getResponse().setRawStatusCode(httpEntity.getStatusCodeValue());
            }
            HttpHeaders entityHeaders = httpEntity.getHeaders();
            HttpHeaders responseHeaders = exchange2.getResponse().getHeaders();
            if (!entityHeaders.isEmpty()) {
                entityHeaders.entrySet().stream().forEach(entry -> responseHeaders.put((String)entry.getKey(), (List)entry.getValue()));
            }
            if (httpEntity.getBody() == null || returnValue instanceof HttpHeaders) {
                return exchange2.getResponse().setComplete();
            }
            String etag = entityHeaders.getETag();
            Instant lastModified = Instant.ofEpochMilli(entityHeaders.getLastModified());
            HttpMethod httpMethod = exchange2.getRequest().getMethod();
            if (SAFE_METHODS.contains((Object)httpMethod) && exchange2.checkNotModified(etag, lastModified)) {
                return exchange2.getResponse().setComplete();
            }
            return this.writeBody(httpEntity.getBody(), bodyParameter, actualParameter, exchange2);
        });
    }
}

