/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.support.BindingAwareConcurrentModel;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BindingContext {
    @Nullable
    private final WebBindingInitializer initializer;
    private final Model model = new BindingAwareConcurrentModel();

    public BindingContext() {
        this(null);
    }

    public BindingContext(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public Model getModel() {
        return this.model;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, @Nullable Object target, String name) {
        ExtendedWebExchangeDataBinder dataBinder = new ExtendedWebExchangeDataBinder(target, name);
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        return this.initDataBinder(dataBinder, exchange2);
    }

    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, String name) {
        return this.createDataBinder(exchange2, null, name);
    }

    private static class ExtendedWebExchangeDataBinder
    extends WebExchangeDataBinder {
        public ExtendedWebExchangeDataBinder(@Nullable Object target, String objectName) {
            super(target, objectName);
        }

        @Override
        public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange2) {
            Map vars = exchange2.getAttributeOrDefault(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
            MultiValueMap<String, String> queryParams = exchange2.getRequest().getQueryParams();
            Mono<MultiValueMap<String, String>> formData = exchange2.getFormData();
            Mono<MultiValueMap<String, Part>> multipartData = exchange2.getMultipartData();
            return Mono.zip(Mono.just(vars), Mono.just(queryParams), formData, multipartData).map(tuple -> {
                TreeMap result = new TreeMap();
                ((Map)tuple.getT1()).forEach(result::put);
                ((MultiValueMap)tuple.getT2()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue(result, key, values));
                ((MultiValueMap)tuple.getT3()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue(result, key, values));
                ((MultiValueMap)tuple.getT4()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue(result, key, values));
                return result;
            });
        }
    }
}

