/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.reactivex.netty.channel.DefaultChannelWriter;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.http.server.HttpResponseHeaders;
import io.reactivex.netty.server.ServerChannelMetricEventProvider;
import io.reactivex.netty.server.ServerMetricsEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;

public class HttpServerResponse<T>
extends DefaultChannelWriter<T> {
    private final HttpResponseHeaders headers;
    private final HttpResponse nettyResponse;
    private final AtomicBoolean headerWritten = new AtomicBoolean();
    private volatile boolean fullResponseWritten;
    private ChannelFuture headerWriteFuture;
    private volatile boolean flushOnlyOnReadComplete;

    protected HttpServerResponse(Channel nettyChannel, MetricEventsSubject<? extends ServerMetricsEvent<?>> eventsSubject) {
        this(nettyChannel, HttpVersion.HTTP_1_1, eventsSubject);
    }

    protected HttpServerResponse(Channel nettyChannel, HttpVersion httpVersion, MetricEventsSubject<? extends ServerMetricsEvent<?>> eventsSubject) {
        this(nettyChannel, new DefaultHttpResponse(httpVersion, HttpResponseStatus.OK), eventsSubject);
    }

    HttpServerResponse(Channel nettyChannel, HttpResponse nettyResponse, MetricEventsSubject<? extends ServerMetricsEvent<?>> eventsSubject) {
        super(nettyChannel, eventsSubject, ServerChannelMetricEventProvider.INSTANCE);
        this.nettyResponse = nettyResponse;
        this.headers = new HttpResponseHeaders(nettyResponse);
    }

    public HttpResponseHeaders getHeaders() {
        return this.headers;
    }

    public void addCookie(Cookie cookie) {
        this.headers.add("Set-Cookie", (Object)ServerCookieEncoder.encode(cookie));
    }

    public void setStatus(HttpResponseStatus status) {
        this.nettyResponse.setStatus(status);
    }

    public HttpResponseStatus getStatus() {
        return this.nettyResponse.getStatus();
    }

    @Override
    public Observable<Void> close() {
        return this.close(true);
    }

    @Override
    public Observable<Void> close(boolean flush) {
        return super.close(flush);
    }

    @Override
    public Observable<Void> _close(boolean flush) {
        this.writeHeadersIfNotWritten();
        if (!this.fullResponseWritten && (this.headers.isTransferEncodingChunked() || this.headers.isKeepAlive())) {
            this.writeOnChannel(new DefaultLastHttpContent());
        }
        return flush ? this.flush() : Observable.empty();
    }

    public void writeChunkedInput(HttpChunkedInput httpChunkedInput) {
        this.writeOnChannel(httpChunkedInput);
    }

    public void flushOnlyOnChannelReadComplete(boolean flushOnlyOnReadComplete) {
        this.flushOnlyOnReadComplete = flushOnlyOnReadComplete;
    }

    public boolean isFlushOnlyOnReadComplete() {
        return this.flushOnlyOnReadComplete;
    }

    HttpResponse getNettyResponse() {
        return this.nettyResponse;
    }

    boolean isHeaderWritten() {
        return null != this.headerWriteFuture && this.headerWriteFuture.isSuccess();
    }

    @Override
    protected ChannelFuture writeOnChannel(Object msg) {
        if (!HttpServerResponse.class.isAssignableFrom(msg.getClass())) {
            if (msg instanceof ByteBuf) {
                ByteBuf content = (ByteBuf)msg;
                long contentLength = this.headers.getContentLength(-1L);
                if (-1L != contentLength && contentLength == (long)content.readableBytes() && this.headerWritten.compareAndSet(false, true)) {
                    return this.writeFullResponse((ByteBuf)msg);
                }
            }
            this.writeHeadersIfNotWritten();
        } else {
            long contentLength = this.headers.getContentLength(-1L);
            if (0L == contentLength && this.headerWritten.compareAndSet(false, true)) {
                return this.writeFullResponse((ByteBuf)msg);
            }
        }
        return super.writeOnChannel(msg);
    }

    private ChannelFuture writeFullResponse(ByteBuf content) {
        this.fullResponseWritten = true;
        DelegatingFullHttpResponse fhr = new DelegatingFullHttpResponse(this.nettyResponse, content);
        return super.writeOnChannel(fhr);
    }

    protected void writeHeadersIfNotWritten() {
        if (this.headerWritten.compareAndSet(false, true)) {
            if (!this.headers.contains("Content-Length")) {
                this.headers.add("Transfer-Encoding", (Object)"chunked");
            }
            this.headerWriteFuture = super.writeOnChannel(this);
        }
    }

    private static class DelegatingFullHttpResponse
    implements FullHttpResponse {
        private final HttpResponse headers;
        private final ByteBuf content;
        private final HttpHeaders trailingHeaders;

        public DelegatingFullHttpResponse(HttpResponse headers2, ByteBuf content) {
            this.headers = headers2;
            this.content = content;
            this.trailingHeaders = new DefaultHttpHeaders(false);
        }

        public static FullHttpResponse newWithNoContent(HttpResponse headers2, ByteBufAllocator allocator) {
            headers2.headers().set("Content-Length", (Object)0);
            return new DelegatingFullHttpResponse(headers2, allocator.buffer(0));
        }

        @Override
        public FullHttpResponse copy() {
            return this.copy(this.content.copy());
        }

        public FullHttpResponse copy(ByteBuf newContent) {
            DefaultFullHttpResponse copy = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), newContent);
            copy.headers().set(this.headers());
            copy.trailingHeaders().set(this.trailingHeaders());
            return copy;
        }

        @Override
        public FullHttpResponse duplicate() {
            DefaultFullHttpResponse dup = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), this.content.duplicate());
            dup.headers().set(this.headers());
            dup.trailingHeaders().set(this.trailingHeaders());
            return dup;
        }

        @Override
        public FullHttpResponse retain(int increment) {
            this.content.retain(increment);
            return this;
        }

        @Override
        public FullHttpResponse retain() {
            this.content.retain();
            return this;
        }

        @Override
        public FullHttpResponse touch() {
            this.content.touch();
            return this;
        }

        @Override
        public FullHttpResponse touch(Object hint) {
            this.content.touch(hint);
            return this;
        }

        @Override
        public FullHttpResponse setProtocolVersion(HttpVersion version) {
            this.headers.setProtocolVersion(version);
            return this;
        }

        @Override
        public FullHttpResponse setStatus(HttpResponseStatus status) {
            this.headers.setStatus(status);
            return this;
        }

        @Override
        public ByteBuf content() {
            return this.content;
        }

        @Override
        public HttpResponseStatus getStatus() {
            return this.headers.status();
        }

        @Override
        public HttpResponseStatus status() {
            return this.headers.status();
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.headers.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.headers.protocolVersion();
        }

        @Override
        public HttpHeaders headers() {
            return this.headers.headers();
        }

        @Override
        public HttpHeaders trailingHeaders() {
            return this.trailingHeaders;
        }

        @Override
        public DecoderResult getDecoderResult() {
            return DecoderResult.SUCCESS;
        }

        @Override
        public DecoderResult decoderResult() {
            return DecoderResult.SUCCESS;
        }

        @Override
        public void setDecoderResult(DecoderResult result) {
        }

        @Override
        public int refCnt() {
            return this.content.refCnt();
        }

        @Override
        public boolean release() {
            return this.content.release();
        }

        @Override
        public boolean release(int decrement) {
            return this.content.release(decrement);
        }
    }
}

