/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util;

import java.util.SortedMap;
import java.util.TreeMap;

public class IntervalMap<T> {
    final SortedMap<Interval, T> from = new TreeMap<Interval, T>();

    public void add(T val, long from, long to) {
        this.from.put(new Interval(from, to), val);
    }

    public T get(long k) {
        Interval i2 = new Interval(k, k);
        Object key = this.from.get(i2);
        if (key != null) {
            return (T)key;
        }
        SortedMap<Interval, T> head = this.from.headMap(i2);
        if (head.isEmpty()) {
            return null;
        }
        Interval last = head.lastKey();
        if (k >= last.from && k < last.to) {
            return (T)this.from.get(last);
        }
        return null;
    }

    public void merge(IntervalMap<T> other) {
        this.from.putAll(other.from);
    }

    static final class Interval
    implements Comparable<Interval> {
        final long from;
        final long to;

        public Interval(long from, long to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public int compareTo(Interval other) {
            return Long.compare(this.from, other.from);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.from ^ this.from >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interval other = (Interval)obj;
            return this.from == other.from;
        }
    }
}

