/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy,
Lifecycle {
    private static final ThreadLocal<WebSocketHandlerContainer> adapterHolder = new NamedThreadLocal<WebSocketHandlerContainer>("JettyWebSocketHandlerAdapter");
    @Nullable
    private WebSocketPolicy webSocketPolicy;
    @Nullable
    private WebSocketServerFactory factory;
    @Nullable
    private volatile ServletContext servletContext;
    private volatile boolean running;
    private final Object lifecycleMonitor = new Object();

    public void setWebSocketPolicy(WebSocketPolicy webSocketPolicy) {
        this.webSocketPolicy = webSocketPolicy;
    }

    @Nullable
    public WebSocketPolicy getWebSocketPolicy() {
        return this.webSocketPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            ServletContext servletContext = this.servletContext;
            if (!this.isRunning() && servletContext != null) {
                try {
                    this.factory = this.webSocketPolicy != null ? new WebSocketServerFactory(servletContext, this.webSocketPolicy) : new WebSocketServerFactory(servletContext);
                    this.factory.setCreator((request, response) -> {
                        WebSocketHandlerContainer container = adapterHolder.get();
                        String protocol = container.getProtocol();
                        if (protocol != null) {
                            response.setAcceptedSubProtocol(protocol);
                        }
                        return container.getAdapter();
                    });
                    this.factory.start();
                    this.running = true;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Unable to start WebSocketServerFactory", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning() && this.factory != null) {
                try {
                    this.factory.stop();
                    this.running = false;
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to stop WebSocketServerFactory", ex);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpServletRequest servletRequest = (HttpServletRequest)ServerHttpRequestDecorator.getNativeRequest(request);
        HttpServletResponse servletResponse = (HttpServletResponse)ServerHttpResponseDecorator.getNativeResponse(response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory factory = response.bufferFactory();
        this.startLazily(servletRequest);
        Assert.state(this.factory != null, "No WebSocketServerFactory available");
        boolean isUpgrade = this.factory.isUpgradeRequest(servletRequest, servletResponse);
        Assert.isTrue(isUpgrade, "Not a WebSocket handshake");
        return exchange2.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(ContextWebSocketHandler.decorate(handler, contextView), session -> new JettyWebSocketSession((Session)session, handshakeInfo, factory));
            try {
                adapterHolder.set(new WebSocketHandlerContainer(adapter, subProtocol));
                this.factory.acceptWebSocket(servletRequest, servletResponse);
            }
            catch (IOException ex) {
                Mono mono = Mono.error(ex);
                return mono;
            }
            finally {
                adapterHolder.remove();
            }
            return Mono.empty();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLazily(HttpServletRequest request) {
        if (this.isRunning()) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.servletContext = request.getServletContext();
                this.start();
            }
        }
    }

    private static class WebSocketHandlerContainer {
        private final JettyWebSocketHandlerAdapter adapter;
        @Nullable
        private final String protocol;

        public WebSocketHandlerContainer(JettyWebSocketHandlerAdapter adapter, @Nullable String protocol) {
            this.adapter = adapter;
            this.protocol = protocol;
        }

        public JettyWebSocketHandlerAdapter getAdapter() {
            return this.adapter;
        }

        @Nullable
        public String getProtocol() {
            return this.protocol;
        }
    }
}

