/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.methodhandler.fallback;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.utils.FeignUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FallbackMethodHandler
implements MethodHandler {
    private final Method method;
    private final Type returnPublisherType;
    private final MethodHandler methodHandler;
    private final Function<Throwable, Object> fallbackFactory;

    FallbackMethodHandler(Target target, MethodMetadata methodMetadata, MethodHandler methodHandler, Function<Throwable, Object> fallbackFactory) {
        Util.checkNotNull(target, "target must be not null", new Object[0]);
        Util.checkNotNull(methodMetadata, "methodMetadata must be not null", new Object[0]);
        this.method = FeignUtils.findMethodInTarget(target, methodMetadata);
        this.method.setAccessible(true);
        this.returnPublisherType = ((ParameterizedType)methodMetadata.returnType()).getRawType();
        this.methodHandler = Util.checkNotNull(methodHandler, "methodHandler must be not null", new Object[0]);
        this.fallbackFactory = Util.checkNotNull(fallbackFactory, "fallbackFactory must be not null", new Object[0]);
    }

    @Override
    public Publisher<Object> invoke(Object[] argv) {
        Publisher publisher;
        try {
            publisher = (Publisher)this.methodHandler.invoke(argv);
        }
        catch (Throwable throwable2) {
            publisher = Mono.error(throwable2);
        }
        if (this.returnPublisherType == Mono.class) {
            return ((Mono)publisher).onErrorResume(throwable -> {
                Object fallback = this.fallbackFactory.apply((Throwable)throwable);
                Object fallbackValue = this.getFallbackValue(fallback, this.method, argv);
                return (Mono)fallbackValue;
            });
        }
        if (this.returnPublisherType == Flux.class) {
            return ((Flux)publisher).onErrorResume(throwable -> {
                Object fallback = this.fallbackFactory.apply((Throwable)throwable);
                Object fallbackValue = this.getFallbackValue(fallback, this.method, argv);
                return (Publisher)fallbackValue;
            });
        }
        throw new IllegalArgumentException("Unknown returnPublisherType: " + this.returnPublisherType);
    }

    private Object getFallbackValue(Object target, Method method2, Object[] argv) {
        try {
            return method2.invoke(target, argv);
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
    }
}

